function getRandomString(length) {

    var charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"
    var result = ""
	var values = new Uint32Array(length)

    window.crypto.getRandomValues(values)

	for (var i=0; i<length; i++) {
		result += charset[values[i] % charset.length]
	}

	return result
}

function getCodeValue() {
	return $("input").val()
}

function getHash(salt, code) {
	var sha = new jsSHA("SHA-256", "TEXT")
	sha.update("" + salt + code)
	return sha.getHash("HEX")
}

function login(code) {

	if (!code) {
		return handleError("Missing code input")
	}

	var salt = getRandomString(128)
	var hash = getHash(salt, code)

	var data = {
		salt: salt,
		hash: hash
	}

	$("input").blur()

	jQuery.post("login", data)
		.fail(function(error) {
			return handleError("Error: " + error)
		})
		.done(function(data) {
			if (!data) { return handleError("No response, try again.") }
			if (data.error) { return handleError(data.error) }
			window.location = data.redirect
		})
}

function handleError(err) {
	console.error(err)
	$("#error").html(err)
	$("body").addClass("error")
}

function resetError() {
	$("#error").html("")
	$("body").removeClass("error")
}

function handleKeyPress(event) {

	var regex = /[0-9]|\./
	var key = String.fromCharCode(event.keyCode || event.which)

	if (!regex.test(key)) {
		event.returnValue = false
		event.preventDefault()
		return
	}
}

function handleFocus(event) {

	var code = getCodeValue()

	if (code.length == 6) {
		$("input").val("")
	}

	resetError()
}

function handleChange(event) {

	var code = getCodeValue();

	if (code.length == 6) {
		return login(code)
	}

	if (code !== "") {
		resetError()
	}
}

$(document).ready(function() {

	$(".code").keypress(handleKeyPress)
	$(".code").click(handleFocus)
	$(".code").on("input propertychange", handleChange)

	var isAndroid = /(android)/i.test(navigator.userAgent)

	if (isAndroid) {
		$(".main").addClass("android")
		// $(".main").prepend($("#error"))
		// $(".main").prepend($(".inputwrapper"))
	}

	$(".-framer-close-prototype-button").click(function(){

		try {
			webkit.messageHandlers.exitHandler.postMessage("exit");
		} catch(err) {
			console.log('The native context does not exist yet');
		}
	});
})
