import sys
import os
import plistlib
import logging

def get_defaults_path(domain):
	return os.path.expanduser("~/Library/Preferences/{0}".format(domain))

def get_defaults_data(path):
	try:
		with open(path, "r") as f:
			data = plistlib.readPlistFromString(f.read())
		return data
	except:
		return {}

def set_defaults_data(path, data):
	try:
		with open(path, "w") as f:
			f.write(plistlib.writePlistToString(data))
	except Exception, e:
		logging.error("Could not write defaults: %s", e)


def set_default(domain, key, value):

	path = get_defaults_path(domain)
	data = get_defaults_data(path)

	data[key] = value

	set_defaults_data(path, data)

def get_default(domain, key):

	path = get_defaults_path(domain)
	data = get_defaults_data(path)

	try:
		return data[key]
	except KeyError, e:
		return None

class Defaults(object):

	def __init__(self, domain):
		self.domain = domain

	def set(self, key, value):
		return set_default(self.domain, key, value)

	def get(self, key):
		return get_default(self.domain, key)