{SVGLayer}  = require './SVGLayer'
{Shapes} = require './Shapes'

class exports.SnappingVisualizer

	shapes = new Shapes()

	constructor: ->
		@ctx = new Framer.Context name: "SnappingVisualizer"

	showSnapLine: (layer, linePoint) =>

		@ctx.run ->
			@svgLayer = new SVGLayer(stroke: "#48CFFF") unless @svgLayer
			@svgLayer.clear()

			pointA = Utils.convertPointToContext(linePoint.pointA, layer, true, false)
			pointB = Utils.convertPointToContext(linePoint.pointB, layer, true, false)

			# make straight lines continue to edge of screen
			straightLine = @svgLayer.straightLine([pointA, pointB])

			if straightLine && pointA.x is pointB.x
				# vertical
				pointA.y = 0
				pointB.y = screen.height

			if straightLine && pointA.y is pointB.y
				# horizontal
				pointA.x = 0
				pointB.x = screen.width

			@svgLayer.addLine(pointA, pointB)

	snaps: (layer, horizontalSnapCoordinates, verticalSnapCoordinates) =>

		ptInSuper = @pointsInSuper(layer)

		hCoords = @orderedCoords(horizontalSnapCoordinates, "x", ptInSuper) if horizontalSnapCoordinates?
		vCoords = @orderedCoords(verticalSnapCoordinates, "y", ptInSuper) if verticalSnapCoordinates?
		hLinePoints = @linePoints(hCoords, "x") or []
		vLinePoints = @linePoints(vCoords, "y") or []

		@ctx.run ->
			@svgLayer = new SVGLayer(stroke: "#48CFFF") unless @svgLayer
			@svgLayer.clear()

			for linePoint in hLinePoints

				pointA = Utils.convertPointToContext(linePoint.a, layer, true, false)
				pointB = Utils.convertPointToContext(linePoint.b, layer, true, false)

				# make straight lines continue to edge of screen
				straightLine = @svgLayer.straightLine([pointA, pointB])

				if straightLine && pointA.x is pointB.x
					# vertical
					pointA.y = 0
					pointB.y = screen.height

				@svgLayer.addLine(pointA, pointB)

			for linePoint in vLinePoints

				pointA = Utils.convertPointToContext(linePoint.a, layer, true, false)
				pointB = Utils.convertPointToContext(linePoint.b, layer, true, false)

				# make straight lines continue to edge of screen
				straightLine = @svgLayer.straightLine([pointA, pointB])

				if straightLine && pointA.y is pointB.y
					# horizontal
					pointA.x = 0
					pointB.x = screen.width

				@svgLayer.addLine(pointA, pointB)

	showLayerOutline: (layer) ->

		if layer?

			points = @pointsInContext(layer)
			ancestors = layer.ancestors()
			clippingCoords = null

			for ancestor in ancestors when ancestor.clip

				ancestorCoords = @pointsInContext(ancestor)
				unless shapes.polygonInside(points, ancestorCoords)
					if clippingCoords?
						unless shapes.polygonInside(clippingCoords, ancestorCoords)
							clippingCoords = shapes.intersection(clippingCoords, ancestorCoords)
					else
						clippingCoords = ancestorCoords

			screenCoords = @screenCoordsForLayer(layer)

			if clippingCoords?
				unless shapes.polygonInside(screenCoords, clippingCoords)
					screenCoords = shapes.intersection(clippingCoords, screenCoords)

			polyLines = shapes.difference(points, screenCoords)

			@ctx.run ->
				@outlineLayer = new SVGLayer(strokeWidth: 0, fill: "rgba(127, 127, 127, .2)") unless @outlineLayer
				@outlineLayer.clear()

				if polyLines.length is 2 and shapes.polygonInside(screenCoords, points)
					@outlineLayer.addPolyline(polyLines...)
				else
					for pLine in polyLines
						@outlineLayer.addPolyline(pLine)

	shouldShowRotation: (layer, mouse) ->
		return false unless layer? and mouse?

		points = @pointsInContext(layer)

		innerBounds = shapes.offsetPolyline(points, 4)
		return false if shapes.pointInside(innerBounds, mouse)

		outerBounds = shapes.offsetPolyline(points, 20)
		return true if shapes.pointInside(outerBounds, mouse)

		return false

	shouldAllowMovingLayer: (layer, mouse) ->
		return false unless layer? and mouse?
		points = @pointsInContext(layer)
		return shapes.pointInside(points, mouse)

	hideOutline: ->
		@ctx.run ->
			@outlineLayer?.clear()

	end: ->
		@ctx.run ->
			@svgLayer.clear() if @svgLayer

	linePoints: (orderedCoords, type) ->

		result = []

		dir = "x" if type is "y"
		dir = "y" if type is "x"

		for key in _.keys(orderedCoords)
			coords = orderedCoords[key]
			min = max = coords[0][dir]
			for coord in coords
				min = coord[dir] if coord[dir] < min
				max = coord[dir] if coord[dir] > max

			pointA = {}
			pointA[type] = key
			pointA[dir]	= min
			pointB = {}
			pointB[type] = key
			pointB[dir] = max

			result.push({a:pointA, b:pointB})

		return result

	orderedCoords: (snapCoordinates, type, ptInSuper) ->
		result = {}

		for coord in snapCoordinates when snapCoordinates?
			value = coord[type]
			result["#{value}"] = [] unless result["#{value}"]
			valueArray = result["#{value}"]
			valueArray.push(coord)

		for pt in ptInSuper when ptInSuper?
			value = pt[type]
			valueArray = result["#{value}"]
			valueArray.push(pt) if valueArray

		return result

	screenCoordsForLayer: (layer) =>
		topL = _.last(layer.ancestors()) or layer
		screen = layer.context
		screenCorners = [{x:0, y:0}, {x:screen.width, y:0}, {x:screen.width, y:screen.height}, {x:0, y:screen.height}]
		screenCoords = []
		for c in screenCorners
			coord = Utils.convertPointToContext(c, topL, true, false)
			coord = {x:coord.x, y:coord.y}
			screenCoords.push(coord)
		return screenCoords

	coords =
		topLeft:		x:0, y:0
		topRight:		x:1, y:0
		bottomLeft: 	x:0, y:1
		bottomRight: 	x:1, y:1
		center: 		x:0.5, y:0.5

	pointsInSuper: (layer) =>

		layerPoints = []
		for key, {x, y} of coords
			point = Utils.convertPoint({x:x * layer.width, y:y * layer.height}, layer, layer.superLayer)
			layerPoints.push(point)

		return layerPoints

	pointsInContext: (layer) =>
		contextPoints = []
		for coord in [[0, 0], [1, 0], [1, 1], [0, 1]]
			point = Utils.convertPointToContext({x:coord[0] * layer.width, y:coord[1] * layer.height}, layer, true, true)
			contextPoints.push(point)
		return contextPoints
