{Clipper, IntPoint, ClipperOffset} = require "./clipper"

class ClipType
	@intersection = 0
	@union = 1
	@difference = 2
	@subtract = 3

class exports.Shapes

	cpr = new Clipper()

	intersection: (setA, setB) =>
		return @booleanOperation(setA, setB, ClipType.intersection)

	union: (setA, setB) =>
		return @booleanOperation(setA, setB, ClipType.union)

	difference: (setA, setB) =>
		return @booleanOperation(setA, setB, ClipType.difference)

	subtract: (setA, setB) =>
		return @booleanOperation(setA, setB, ClipType.subtract)

	booleanOperation: (setA, setB, type) =>

		cpr.Clear()

		ptSubject = 0
		ptClip = 1

		a = @clipperizePolylines(setA)
		b = @clipperizePolylines(setB)

		cpr.AddPaths(a, ptSubject, true)
		cpr.AddPaths(b, ptClip, true)

		solution_paths = []
		PolyFillType_pftNonZero = 1

		succeeded = cpr.Execute(type, solution_paths, PolyFillType_pftNonZero, PolyFillType_pftNonZero)

		return @normalisePolylines(solution_paths) if succeeded
		return []

	# clippingMaskInside

	polygonInside: (innerPolyline, outerPolyline) ->

		inner = @clipperizePolylines(innerPolyline)
		outer = @clipperizePolylines(outerPolyline)

		polygonInside = true

		if outer? and inner? and outer.length > 0 and inner.length > 0
			for point in inner[0]
				pt = new IntPoint(point.X, point.Y)
				if Clipper.PointInPolygon(pt, outer[0]) is 0
					polygonInside = false
					break

		return polygonInside

	pointInside: (polyline, point) ->
		pt = new IntPoint(point.x, point.y)
		polyline = @clipperizePolylines(polyline)
		return Clipper.PointInPolygon(pt, polyline[0]) isnt 0

	offsetPolyline: (polyline, offset) ->
		clipperPolyline = @clipperizePolylines(polyline)

		co = new ClipperOffset(2, 0.25)
		scale = 100
		subj = clipperPolyline

		jtSquare = 0
		# jtRound = 1
		# jtMiter = 2

		etClosedPolygon = 4
		co.AddPaths(subj, jtSquare, etClosedPolygon)
		solution = []
		co.Execute(solution, offset)
		normalisedPolyline = @normalisePolylines(solution)

		return normalisedPolyline[0] if normalisedPolyline.length > 0
		return []

	# helper functions

	clipperizePolyline: (polyLine) ->

		result = []

		for inputPoint in polyLine
			point =
				X: inputPoint.x
				Y: inputPoint.y
			result.push(point)

		return result

	normalisePolyline: (polyLine) ->

		result = []

		for inputPoint in polyLine
			point =
				x: inputPoint.X
				y: inputPoint.Y
			result.push(point)

		return result

	clipperizePolylines: (polyLines) =>

		result = []

		if polyLines.length and !_.isArray(polyLines[0])
			return [@clipperizePolyline(polyLines)]

		for polyLine in polyLines
			clip = @clipperizePolyline(polyLine)
			result.push(clip)

		return result


	normalisePolylines: (polyLines) =>

		result = []

		if polyLines.length and !_.isArray(polyLines[0])
			return [@normalisePolyline(polyLines)]

		for polyLine in polyLines
			normalized = @normalisePolyline(polyLine)
			result.push(normalized)

		return result
