class exports.Point
	constructor: (x, y) ->
		@x = x
		@y = y
	
	distance: (pointB) =>
		return Utils.pointDistance(@, pointB)

class exports.Line
	constructor: (pointA, pointB) ->
		@pointA = pointA
		@pointB = pointB
	
	length: =>
		@_distance = @pointA.distance(@pointB) unless @_distance?
		return @_distance
	
	intersection: (lineB) =>

		# create perpendicular line if we get a point
		if lineB.x? and lineB.y?
			deltaX = @pointA.x - @pointB.x
			deltaY = @pointA.y - @pointB.y
			point = new exports.Point(lineB.x - deltaY, lineB.y + deltaX)
			lineB = new exports.Line(lineB, point)
	
		return null unless lineB instanceof exports.Line
	
		x1 = @pointA.x
		y1 = @pointA.y
		x2 = @pointB.x
		y2 = @pointB.y
		x3 = lineB.pointA.x
		y3 = lineB.pointA.y
		x4 = lineB.pointB.x
		y4 = lineB.pointB.y
		d = (x1-x2)*(y3-y4) - (y1-y2)*(x3-x4)
		return null if d is 0
		
		xi = ((x3-x4)*(x1*y2-y1*x2)-(x1-x2)*(x3*y4-y3*x4))/d
		yi = ((y3-y4)*(x1*y2-y1*x2)-(y1-y2)*(x3*y4-y3*x4))/d
		return new exports.Point(xi,yi)