
{bridge}                =(require "./Bridge.coffee")
{runtime}               =(require "./Runtime.coffee")
context                 =(require "./Context.coffee")
{HighlightComponent}    = require "./highlight/HighlightComponent.coffee"
{EditStateController}   = require "./edit/EditStateController.coffee"
{StateController}       = require "./state/StateController.coffee"
{WebMIDIAPIShim}        = require "./midi/WebMIDIAPIShim"
{requestSourceCode}     = require "./code/CodeAccess"

exports.bridge = bridge
exports.runtime = runtime
exports.context = context

# Add simple require function if it's not there
window.require ?= (module) -> throw Error("Module #{module} can't be found")

deviceContext = Framer.CurrentContext

setupContext = ->

    # Context listeners
    context = new context.ContextListener(Framer.CurrentContext)

    # State management
    controller = new StateController(deviceContext)

if window?
    window.FramerStudio = exports
    setupContext()

navigator?.requestMIDIAccess = WebMIDIAPIShim.requestMIDIAccess
navigator?.requestSourceCode = requestSourceCode 
