class exports.BorderRadiusHandle extends Layer

	minDragHandleDistanceToEnableBorderHandle = 30
	minDistanceFromCorner = 12

	constructor: (options = {}) ->
		options = _.defaults options,
			size: 4
			borderRadius: 4
			backgroundColor: "rgb(255,255,255)"
			shadowSpread: 1
			shadowColor: "rgb(0,0,0)"

		super options

		@states =
			normal: opacity: 0.5
			active: opacity: 1.0
			locked: opacity: 0.5

	setCenterPoint: (point) =>
		@midX = point.x
		@midY = point.y

	updateMousePos: (mouse) =>
		return unless mouse?
		centerPoint = {x:@midX, y:@midY}
		@_distance = Utils.pointDistance(mouse, centerPoint)
		return @distance

	updatePosition: =>
		layer = @dragHandle.layer
		return unless layer?

		width = layer.width
		height = layer.height

		return @_active = false if minDragHandleDistanceToEnableBorderHandle > _.min(@dragHandle.neighborDistances())
		@_active = true

		fx = 0.5
		fx = (layer.height / layer.width) * 0.5 if width > height
		fy = 0.5
		fy = (layer.width / layer.height) * 0.5 if height > width

		@cornerPoint = @dragHandle.point
		@centerPoint = Utils.convertPointToContext({x:fx * layer.width, y:fy * layer.height}, layer, true, true)

		maxRadius = Math.min(width / 2, height / 2)
		minFactor = minDistanceFromCorner / Utils.pointDistance(@cornerPoint, @centerPoint)
		currentRadius = Utils.clamp(layer.borderRadius, minFactor * maxRadius, maxRadius)

		factor = currentRadius / maxRadius

		pointOnLine = @pointOnLine(@cornerPoint, @centerPoint, factor)

		@setCenterPoint(pointOnLine)

	inDragDistance: (mouse) =>
		@updateMousePos(mouse) if mouse?
		return @distance < 8 if @distance? and @isActive
		return false

	@define "distance",
		get: ->
			return @_distance if @_distance?
			return null

	@define "isActive",
		get: ->
			return @_active if @_active?
			return false

	@define "dragHandle",
		get: -> return @_dragHandle
		set: (value) -> @_dragHandle = value

	pointOnLine: (pointA, pointB, fraction) ->
		xDiff = pointB.x - pointA.x
		YDiff = pointB.y - pointA.y
		result = {x:pointA.x + xDiff * fraction, y:pointA.y + YDiff * fraction}
