class exports.ScaleTool

	start: (editor) =>
		@startScale = Math.max(editor.layer.scale, 0.1)
		editor.viewController.render()
		@startDistance =  Utils.pointDistance(editor.mouse, editor.viewController.origin.centerPoint)
		@snapDistances = [1, 0.5, 2, 2.5, 3, 3.5].map(@snapDistanceForScale)

	end: (editor) =>
		editor.updateLayerInfo()
		editor.viewController.render()
		@startDistance = @startScale = @snapDistances = null

	# if we want only to enable snapping with shift we can get shift key updates using the following handlers
	# handleKeyDown: => @update(arguments...)
	# handleKeyUp: => @update(arguments...)

	handleMouseMove: => @update(arguments...)

	update: (event, editor) =>
		origin = editor.viewController.origin
		mouse = editor.mouse
		distanceToCenter = Utils.pointDistance(mouse, origin.centerPoint)

		# snapping
		snap = _.find(@snapDistances, (value) -> Math.abs(value - distanceToCenter) < 6)
		distanceToCenter = snap if snap?

		origin._distance = distanceToCenter
		newScale = Utils.modulate(distanceToCenter, [0, @startDistance], [0, @startScale], false)
		editor.layer.scale = Math.round(newScale * 100) / 100

	snapDistanceForScale: (scale) =>
		return Utils.modulate(scale, [0, @startScale], [0, @startDistance], false)
