{TransformStates} 		= require "./TransformStates"
{OriginTool} 			= require "./tools/OriginTool"
{ScaleTool} 			= require "./tools/ScaleTool"
{EditStates} 			= require "../EditStates"

class exports.TransformController

	constructor: ->
		window.addEventListener "blur", @exit, true

		@originTool = 	new OriginTool
		@scaleTool = 	new ScaleTool

	start: (editor) =>
		@state = TransformStates.idle
		@editor = editor
		@stateForPosition(editor.mouse) if editor.mouse?
		editor.viewController.render()

	exit: =>
		return unless @editor?
		if @editor.state == EditStates.transform
			@editor.exit()
		@editor = null

	# interaction

	handleMouseDown: (event, editor) =>
		return unless @state is TransformStates.idle or TransformStates.locked
		state = @stateForPosition(editor.mouse)
		@updateState(state)
		editor.tooltip.showInfo(editor)

	handleMouseUp: (event, editor) =>
		@controllerForState()?.end?(editor)
		@updateState(TransformStates.idle)
		return @exit() unless event.metaKey
		editor.viewController.render()

	handleMouseMove: (event, editor) =>

		return @exit() if @state is TransformStates.idle and !event.metaKey

		editor.cursorController.remove() if @state is TransformStates.idle

		controller = @controllerForState()
		if controller?
			controller.handleMouseMove(event, editor)
			return editor.viewController.render()

		return unless @state is TransformStates.idle or TransformStates.locked
		state = @stateForPosition(editor.mouse)
		origin = @editor.viewController.origin
		editor.viewController.render()

	handleKeyDown: (event, editor) =>
		@controllerForState()?.handleKeyDown?(event, editor)

	handleKeyUp: (event, editor) =>

		controller = @controllerForState()
		return controller.handleKeyUp?(event, editor) if controller?

		@exit() if @state is TransformStates.idle and !event.metaKey

	handleMouseOut: (event, editor) =>
		@stateForPosition(editor.mouse)
		editor.viewController.render()

	layerChanged: =>
		return @state is TransformStates.origin or @state is TransformStates.scaling

	# states

	stateForPosition: (mouse) =>

		origin = @editor.viewController.origin
		return unless origin?
		origin.updateMousePos(mouse)
		if origin.inDragDistance()
			if @editor.propertyLock.origin()
				@editor.cursorController.showLock()
				return TransformStates.locked
			@editor.cursorController.remove()
			return TransformStates.origin
		if @editor.propertyLock.scale()
			@editor.cursorController.showLock()
			return TransformStates.locked
		@editor.cursorController.showScaleCursor(origin.centerPoint, mouse) if mouse?
		return TransformStates.scaling
		return TransformStates.idle

	updateState: (newState) =>
		return if @state is newState
		@state = newState
		@controllerForState()?.start?(@editor)

	controllerForState: =>

		switch @state
			when TransformStates.origin 	then return @originTool
			when TransformStates.scaling	then return @scaleTool
