class exports.TooltipLayer extends Layer

	constructor: (options = {}) ->

		options = _.defaults options,
			backgroundColor: "rgba(0,0,0,0.5)"
			color: "white"
			borderRadius: 3
			shadowColor: "rgba(255,255,255,0.2)"
			shadowSpread: 1
			width: 60
			height: 23
			index: 100000
			style:
				textAlign: "center"
				font: "-apple-system"
				fontWeight: "bold"
				fontSize: "11px"
				lineHeight: "24px"
				textShadow: "0px 1px 0px rgba(0,0,0,0.1)"
		super options

	showProperties: (properties) =>

		propertyCount = _.keys(properties).length
		index = 1
		smallKey = false
		text = ""

		for key, value of properties
			smallKey = true if key.length is 1
			text += key + ": " + "#{value}"
			text += " &nbsp;" if index < propertyCount
			index++

		@html = text

		charCount = text.length
		charCount -= ((propertyCount - 1) * 8) if propertyCount > 1
		charCount -= 5 if text.indexOf("&#176;") isnt -1
		charCount += 2 if smallKey and propertyCount is 2

		@width = (charCount * 7)
		@visible = true
