class exports.ResizingTool

	start: (editor) =>
		@layerFrame = editor.layer.frame
		@startAnchor = @anchor(editor.layer, editor.activeHandle)
		@centerAnchor = @anchor(editor.layer, {fx:0.5, fy:0.5})
		editor.viewController.render(editor.activeHandle)

	end: (editor) =>
		@layerFrame = @startAnchor = @centerAnchor = null
		editor.snappingVisualizer.end()

	handleKeyDown: (event, editor) ->
		if event.keyCode == 16
			editor.layerChanged()

	handleKeyUp: (event, editor) ->
		if event.keyCode == 16
			editor.layerChanged()

	handleMouseMove: (event, editor) =>

		handle = editor.activeHandle
		relatedLayers = editor.relatedLayers
		layer = editor.layer
		layer.frame = @layerFrame
		{fx, fy} = handle

		convertedDragPoint = Utils.convertPointFromContext(editor.mouse, layer, true, false)

		if event.ctrlKey and event.metaKey
			parentDot = convertedDragPoint
		else

			if fx is 0.5 or fy is 0.5
				snapResult = editor.snappingModel.moveHandleWithConstraints(layer, relatedLayers, convertedDragPoint, handle, handle.oppositeHandle())
			else
				snapResult = editor.snappingModel.moveHandle(layer, relatedLayers, convertedDragPoint, handle)
			parentDot = snapResult.point

		inSelf = Utils.convertPoint(parentDot, layer.superLayer, layer)

		if event.shiftKey and not editor.propertyLock.resizingConstraints(handle)
			if fx isnt 0.5 and fy isnt 0.5
				inSelf = Utils.convertPointFromContext(editor.mouse, layer, true, true)
				editor.snappingVisualizer.end()

		if fx isnt 0.5

			width = inSelf.x

			if event.altKey and not editor.propertyLock.resizingMirror(handle)
				width *= 2
				width -= layer.width if fx is 1

			width = layer.width - width if fx is 0
			layer.width = width unless width < 0

			if width < 0
				layer.width = -width
				fx = 1 - fx
				flippedX = true

		if fy isnt 0.5

			height = inSelf.y

			if event.altKey and not editor.propertyLock.resizingMirror(handle)
				height *= 2
				height -= layer.height if fy is 1

			height = layer.height - height if fy is 0
			layer.height = height unless height < 0

			if height < 0
				layer.height = -height
				fy = 1 - fy
				flippedY = true

		if event.shiftKey and not editor.propertyLock.resizingConstraints(handle)

			ratio = @layerFrame.width / @layerFrame.height

			ratioheight = layer.width / ratio
			ratiowidth = layer.height * ratio

			if fy is 0.5
				layer.height = ratioheight
			else if fx is 0.5
				layer.width = ratiowidth
			else
				widthChange = layer.width / ratiowidth
				heightChange = layer.height / ratioheight

				if widthChange < heightChange
					layer.height = ratioheight
				else
					layer.width = ratiowidth

		baseAnchor = @startAnchor

		if event.altKey and not editor.propertyLock.resizingMirror(handle)
			fx = fy = 0.5
			baseAnchor = @centerAnchor

		anchor = @anchor(layer, {fx: fx, fy: fy})

		layer.x += Math.round(baseAnchor.x - anchor.x)
		layer.y += Math.round(baseAnchor.y - anchor.y)
		layer.z += Math.round(baseAnchor.z - anchor.z)

		handle = @activeHandle(editor.activeHandle, flippedX, flippedY)
		handle.updatePosition()
		editor.viewController.render(handle)

		if snapResult? and snapResult.line?
			editor.snappingVisualizer.showSnapLine(layer, snapResult.line)
		else if event.shiftKey or (event.ctrlKey and event.metaKey)
			editor.snappingVisualizer.end()
		else
			editor.snappingVisualizer.snaps(layer, snapResult.horizontalCoordinates, snapResult.verticalCoordinates)

	anchor: (layer, handle) ->
		{fx, fy} = handle
		width = layer.width
		height = layer.height 
		point =
			x: width - width * fx
			y: height - height * fy
		return layer.matrix3d.point(point)

	activeHandle: (handle, flippedX, flippedY) ->
		if flippedX and not flippedY
			return handle.handles[handle.index + 6] if handle.fx is 0
			return handle.handles[handle.index - 6] if handle.fx is 1
		if flippedY and not flippedX
			return handle.handles[handle.index + 2] if handle.fy is 0
			return handle.handles[handle.index - 2] if handle.fy is 1
		if flippedX and flippedY
			return handle.handles[0] if handle.fx is 1 and handle.fy is 1
			return handle.handles[8] if handle.fx is 0 and handle.fy is 0
			return handle.handles[6] if handle.fx is 0 and handle.fy is 1
			return handle.handles[2] if handle.fx is 1 and handle.fy is 0
		return handle
