{ViewerTools}					 = require "../../tools/ViewerTools"

setKeyValue = (object, keyPath, value) ->
	keys = keyPath.split('.')
	for key,index in keys
		if typeof object[key] is 'object'
			object = object[key]
		else if index == keys.length-1
			object[key] = value
		else
			object[key] = {}
			object = object[key]

class exports.AnimationTool extends Framer.BaseClass
	@define 'isLooping',
		get: -> @_isLooping
		set: (looping) ->
			@_isLooping = looping
			if @isLooping and not @isPlaying
				@clickedPlay()

	@define 'isSlomo',
		get: -> @_slomo ? false
		set: (slomo) ->
			@_slomo = slomo
			if slomo
				@previousDelta = Framer.Loop.delta
				Framer.Loop.delta = 1 / 240
			else
				Framer.Loop.delta = @previousDelta

	@define 'isPlaying',
		get: ->
			for preview in @previews
				if preview.isAnimating
					return true
			return false

	constructor: ->
		super
		@reset()

	objectFromDefaults: (defaults, newValues, pick, omit) ->
			result = _.clone(defaults)
			# Pick fixed from original values
			result = _.pick(result, pick)
			# Set destination values to object with defaults
			_.defaults(result, newValues)
			# Omit any values that shouldn't be in here
			_.omit(result, omit)

	hasState: ->
		@target?.state? && @target.state.length > 0

	start: (editor) =>
		editor.cursorController.remove()
		@viewController = editor.viewController
		@layers = ViewerTools.getLayersForTarget(@target)
		@frozen = {}
		for member in @target?.frozenMembers
			setKeyValue(@frozen,member,true)

		distinctProperties = ViewerTools.distinctPropertiesOfLayers(@layers)
		@startPositions = {}
		for layer in @layers
			originalOptions = layer.__framerAnimationInfo?[@target.animation]?.destinationOptions ? {}
			if @hasState()
				properties = @target?.state
				options = @objectFromDefaults(originalOptions, @toValues.options, _.keys(@frozen), ["curveOptions"])
				startKeys = _.keys(layer.states[@target?.state])
			else
				properties = layer.__framerAnimationInfo?[@target.animation]?.destinationProperties
				properties = @objectFromDefaults(properties, @toValues, _.keys(@frozen), ["options"])
				options = @objectFromDefaults(originalOptions, @toValues.options, _.keys(@frozen.options), ["curveOptions"])
				startKeys = _.keys(properties)
			originalState = layer.__framerAnimationInfo?[@target.animation]?.originalState ? {}
			if options.curve? and _.isString(options.curve)
				options.curve = Framer.Curves.fromString(options.curve)
			# If the rotation property wasn't exportable, it wouldn't show up in distinctProperties and we wouldn't have this problem
			if originalState.rotation?
				originalState.rotationZ ?= originalState.rotation
			if originalState.rotationZ?
				originalState.rotation ?= originalState.rotationZ
			startPosition = _.defaults(originalState, _.pick(layer.props, distinctProperties), _.pick(@fromValues, startKeys))
			@startPositions[layer.id] = _.clone(startPosition)

			@applyStartPositionToLayer(layer)
			@animateLayer(layer, properties, options)

	clickedPlay: =>
		if @isPlaying
			@stop()
		else
			@restart()
		@viewController.render()

	stop: =>
		for preview in @previews
			preview.stop()
			preview.reset()

	restart: =>
		for preview in @previews
			unless preview.isNoop
				preview.removeAllListeners Events.AnimationEnd
				preview.once Events.AnimationEnd, @onPreviewAnimationEnd
				preview.restart()

	onPreviewAnimationEnd: =>
		if @isLooping
			if not @isPlaying
				@restart()
		else
			@viewController.render()

	clickedLooping: =>
		@isLooping = not @isLooping
		if not @isLooping
			for preview in @previews
				preview.removeAllListeners Events.AnimationEnd
				preview.once Events.AnimationEnd, @onPreviewAnimationEnd
		@viewController.render()

	clickedSlomo: =>
		@isSlomo = not @isSlomo
		@viewController.render()

	end: (editor) =>
		@isSlomo = false
		for preview in @previews
			preview.finish()
		@previews = null
		@startPosition = null

	isActive: ->
		@previews?

	reset: ->
		@target = null
		@isLooping = false
		@fromValues = {}
		@toValues = {}

	updateProperties: (fromValues, toValues) ->
		@fromValues = _.defaults @fromValues, fromValues
		_.assign(@toValues,toValues)
		if @layers?
			for layer in @layers
				_.defaults(@startPositions[layer.id], @fromValues)

	applyStartPositionToLayer: (layer) =>
		startPosition = @startPositions[layer.id]
		return if not startPosition?
		layer.props = startPosition

	animationPanelPropertyChanged: (name, value) ->
		return if name in ["delay","repeat","options.delay","options.repeat"]
		if name in ["curve", "options.curve"]
			value = Framer.Curves.fromString(value)
		previews = @previews
		if @dragging
			@delayedAnimations?.map (preview) -> preview.stop()
			@delayedAnimations = []
		else
			@previews.map (preview) -> preview.stop()
			@previews = []
		for preview in previews
			options = preview.options
			# Unsetting curveOptions.time, as we want to use te options.time
			delete options['curveOptions']?['time']
			if @hasState()
				setKeyValue(options, name, value)
				properties = preview.properties
			else
				properties = preview.properties
				properties.options = options
				setKeyValue(properties,name,value)
				options = properties.options
				delete properties.options
			@animateLayer(preview.layer, properties, options)

	animateLayer: (layer, properties, options={}) ->
		#Don't preview delay and repeat
		delete options.delay if not @frozen.options?.delay and not @frozen.delay
		delete options.repeat
		options.looping = false
		options.start = false
		animation = layer.animate properties, options
		animation.once Events.AnimationEnd, @onPreviewAnimationEnd
		if @dragging
			@delayedAnimations ?= []
			@delayedAnimations.push(animation)
		else
			@applyStartPositionToLayer(layer)
			@previews ?= []
			@previews.push(animation)
			animation.start()
			@viewController.render()


	handleMouseDown: (event,editor) =>
		@draggingControl = event.target == editor.viewController.animationControl._element
		@draggingOffset = x: event.offsetX, y: event.offsetY

	handleMouseUp: (event,editor) =>
		@draggingControl = false
		@draggingOffset = null

	handleMouseMove: (event,mouse,editor) =>
		return unless @draggingControl
		control = editor.viewController.animationControl
		x = mouse.x - @draggingOffset.x
		y = mouse.y - @draggingOffset.y
		# Keep the control in visible bounds:
		x = Math.max(0,Math.min(x, window.innerWidth - control.width))
		y = Math.max(0,Math.min(y, window.innerHeight - control.height))
		control.x = x
		control.y = y
		control.pixelAlign()

	dragStart: ->
		@dragging = true

	dragEnd: ->
		@dragging = false
		if @delayedAnimations?
			for layer in @layers
				@applyStartPositionToLayer(layer)
			@previews = @delayedAnimations
			@delayedAnimations.map (preview) ->
				preview.start()
			@delayedAnimations = null
