BASE_PROPERTIES = ["x", "y", "width", "height", "rotation", "scale", "scaleX", "scaleY", "originX", "originY", "borderRadius"]

class exports.PropertyLockController

	constructor: ->
		@frozenMembers = null

	attachToLayer: (layer) => @layer = layer

	activeProperties: =>
		properties = BASE_PROPERTIES
		properties = properties.filter(
			(property) -> @frozenMembers.indexOf(property) == -1
			@) if @frozenMembers?
		return properties

	resizingHandle: (handle) =>
		return false unless @layer? and @frozenMembers?

		dependencies = []
		{fx, fy} = handle

		return true if @layer.scale is 0

		if fx in [0, 1]
			return true if @layer.rotationY isnt 0
			dependencies.push("width")
			dependencies.push("x") if fx is 0 or @layerIsTransformed()
			dependencies.push("y") if @layerIsTransformed()
		if fy in [0, 1]
			return true if @layer.rotationX isnt 0
			dependencies.push("height")
			dependencies.push("y") if fy is 0 or @layerIsTransformed()
			dependencies.push("x") if @layerIsTransformed()

		return @isLocked(dependencies)

	resizingConstraints: (handle) =>
		return false unless @layer? and @frozenMembers?
		dependencies = ["width", "height"]
		{fx, fy} = handle

		dependencies.push("x", "y") if @layerIsTransformed() or not (fx is 1 and fy is 1)

		return @isLocked(dependencies)

	resizingMirror: (handle) =>
		return false unless @layer? and @frozenMembers?
		dependencies = []
		{fx, fy} = handle

		dependencies.push("x") unless fx is 0.5
		dependencies.push("y") unless fy is 0.5

		return @isLocked(dependencies)


	rotation: => return @isLocked("rotation")

	translation: => return @x() and @y()

	x: => return @isLocked("x")

	y: => return @isLocked("y")

	origin: => return @isLocked("originX", "originY")

	scale: => return @isLocked("scale")

	borderRadius: => return @isLocked("borderRadius")

	# helpers

	isLocked: (dependencies) =>
		return false unless @frozenMembers?
		dependencies = [arguments...] unless _.isArray(dependencies)
		result = _.find(dependencies, (item) => item in @frozenMembers)?
		return result

	layerIsTransformed: =>
		return false unless @layer?
		return true if @layer.rotation % 360 isnt 0
		return true if @layer.scale isnt 1
		return false
