class exports.Scroller extends Layer

    constructor: (options = {}) ->
        @marginTop = options.y ? 0
        super _.defaults options, {
            name: "Scroller"
            y: @marginTop
            width: window.innerWidth
            height: window.innerHeight - @marginTop
            backgroundColor: null
            clip: true
        }

        @scroll = true
        @scrollHorizontal = false

        window.addEventListener "resize", =>
            @height = window.innerHeight - @marginTop
            @width = window.innerWidth

            for child in @children
                child.handleScrollerResize?(@width, @height)
