{Property,NumberProperty,ColorProperty}  = FramerComponents
{Panel,PanelRow,MonoInputRow,StereoInputRow,PairedInputRow} = FramerComponents
{TextInput,ComboTextInput,NumberInput,SliderInput,DialInput} = FramerComponents

class exports.TransformPanel extends Panel

    constructor: (options = {}) ->

        @caption = "Transform"

        super _.defaults options, {}

        @scaleRow1 = new PairedInputRow
            caption: "Scale"
            editorTypes: [NumberInput, SliderInput]
            rightEditorInsetY: 2
            property: new NumberProperty
                dataPath: "scale"
                min: 0
                sliderMax: 2
                step: 0.05
                decimals: 2
                caption: " "

        @scaleRow2 = new StereoInputRow
            caption: " "
            properties: [
                new NumberProperty dataPath: "scaleX", caption: "X", decimals: 2, step: 0.05
                new NumberProperty dataPath: "scaleY", caption: "Y", decimals: 2, step: 0.05
            ]

        @rotationRow1 = new PairedInputRow
            caption: "Rotation"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "rotation"
                sliderMin: -360
                sliderMax: 360
                decimals: 0
                caption: "Z"

        @rotationRow2 = new StereoInputRow
            caption: " "
            properties: [
                new NumberProperty dataPath: "rotationX", caption: "X"
                new NumberProperty dataPath: "rotationY", caption: "Y"
            ]

        @originRow = new StereoInputRow
            caption: "Origin"
            properties: [
                new NumberProperty
                    dataPath: "originX"
                    caption: "X"
                    decimals: 2
                    step: 0.1
                new NumberProperty
                    dataPath: "originY"
                    caption: "Y"
                    decimals: 2
                    step: 0.1
            ]

        @skewRow = new StereoInputRow
            caption: "Skew"
            properties: [
                new NumberProperty dataPath: "skewX", caption: "X"
                new NumberProperty dataPath: "skewY", caption: "Y"
            ]

        @add @scaleRow1
        @add @scaleRow2
        @add @rotationRow1
        @add @rotationRow2
        @add @originRow
        @add @skewRow
