{FunctionProperty} = FramerComponents

class exports.CurveProperty extends FunctionProperty
    constructor: ->
        super
        @argumentNames = []

    addArgument: (argument, name = null) ->
        super(argument)
        @argumentNames.push(name)

    parseData: (value) ->
        result = Framer.Curves.parseFunction(value)
        return null if not result?
        return null if result.name isnt @name

        @func = Framer.Curves.fromDefinition(result)
        if @func is Framer.Curves.Spring
            @func = @func()
        args = result.arguments
        if _.isObject(result.arguments)
            argumentNames = _.keys(result.arguments)
            args = []
            for key, value of result.arguments
                if key in @argumentNames
                    args.push(value)
        return args

    valueAsString: ->
        return "#{@name}" if not @value?

        zippedValues = _.zipWith @argumentNames, @value, (name, value) ->
            return null if not value?
            return value if not name? or name.length is 0
            return "#{name}: #{value}"
        zippedValues = zippedValues.filter((v) -> v?)
        argumentString = zippedValues.join(', ')
        return "#{@name}(#{argumentString})"
