{Property,OptionListProperty,StringProperty,FunctionProperty,NumberProperty}  = FramerComponents
{Panel,MonoInputRow,WidgetRow,PairedInputRow} = FramerComponents
{NumberInput,SliderInput,RadioSelectInput} = FramerComponents
{Curve} = FramerComponents
{LinearAnimator,BezierCurveAnimator,SpringRK4Animator} = Framer
{CurveProperty} = require "./CurveProperty"

class exports.CurvePanel extends Panel
	constructor: (options = {}) ->
		super options

		@caption = "Curve"

		@curveProperty = new Property
			dataPath: "curve"

		@curveSelectionProperty = new OptionListProperty
			editorType: RadioSelectInput
			availableOptions:
				"linear": "Linear"
				"ease": "Ease"
				"ease-in": "Ease In"
				"ease-out": "Ease Out"
				"ease-in-out": "Ease In Out"
				"spring": "Spring"

		@curveRow = new MonoInputRow
			caption: "Curve"
			editorType: RadioSelectInput
			properties: @curveSelectionProperty

		@widgetRow = new WidgetRow
			widgetType: Curve
			caption: " "

		@add @curveRow
		@add @widgetRow

		@timeProperty = new NumberProperty
			dataPath: "time"
			caption: "S"
			min: 0.01
			sliderMax: 10
			decimals: 2
			step: 0.25

		@springProperty = new CurveProperty
			name: "Spring"
			func: Spring()

		@dampingRatioProperty = new NumberProperty
			min: 0.01
			sliderMin: 0.1
			max: 1
			decimals: 2
			step: 0.01
			caption: " "
			default: Framer.Defaults.Spring.dampingRatio

		massProperty = new NumberProperty
		velocityProperty = new NumberProperty
		toleranceProperty = new NumberProperty

		@springProperty.addArgument(@dampingRatioProperty, "damping")
		@springProperty.addArgument(massProperty, "mass")

		defaultAnimator = new SpringRK4Animator

		@timeRow = new PairedInputRow
			caption: "Time"
			editorTypes: [NumberInput, SliderInput]
			property: @timeProperty

		@dampingRatio = new PairedInputRow
			caption: "Damping"
			editorTypes: [NumberInput, SliderInput]
			rightEditorInsetY: 2
			property: @dampingRatioProperty

		# @timeRow.on "click:disabledLayer", @highlightEaseOption

		@add @timeRow
		@add @dampingRatio

		@properties = [@curveProperty,@timeProperty]

		@curveChangesEnabled = true
		@curveSelectionProperty.on "change:value", @curveSelectionChanged

		@curveSelectionProperty.on "request", (request) =>
			request.name = @curveProperty.dataPath
			@curveProperty.emit "request", request

		@springProperty.on "request", (request) =>
			request.name = @curveProperty.dataPath
			@curveProperty.emit "request", request

		@timeProperty.on "change:value", @springChanged
		@dampingRatioProperty.on "change:value", @springChanged

		@curveProperty.on "change:value", (value) =>
			@curveChangesEnabled = false
			@curveSelectionProperty.settings = @curveProperty.settings
			@springProperty.settings = @curveProperty.settings
			if _.startsWith value, "Spring"
				parsed = Framer.Curves.parseFunction(value)
				argumentKeys = _.keys(parsed.arguments)
				if "tension" in argumentKeys || "friction" in argumentKeys
					@curveSelectionProperty.default = ""
					@curveSelectionProperty.value = ""
					@timeRow.disable()
				else
					@curveSelectionProperty.value = "spring"
					@springProperty.setValueWithData(value)
			else
				value = StringProperty.parseString(value)
				switch value
					when "Bezier.linear" then value = "linear"
					when "Bezier.ease" then value = "ease"
					when "Bezier.easeIn" then value = "ease-in"
					when "Bezier.easeOut" then value = "ease-out"
					when "Bezier.easeInOut" then value = "ease-in-out"
				if not @curveSelectionProperty.validateOption(value)
					@curveSelectionProperty.default = ""
					value = ""
				@curveSelectionProperty.value = value
			@curveChangesEnabled = true

		@curveProperty.on "reset", =>
			@curveSelectionProperty.reset()
			@springProperty.reset()

		@curveProperty.on "change:default", (defaultValue) =>
			@curveChangesEnabled = false
			@curveSelectionProperty.default = defaultValue
			@curveChangesEnabled = true
			if defaultValue?
				@updateWidget()

	highlightSpringOption: =>
		@curveRow.editor.highlight("spring")

	highlightEaseOption: =>
		@curveRow.editor.highlight("ease")

	springChanged: =>
		return unless @curveSelectionProperty.value is "spring"
		@updateCurveProperty(@springProperty.valueAsString())
		@updateWidget()

	updateCurveProperty: (value) ->
		return if not @curveChangesEnabled
		value = StringProperty.parseString(value)
		switch value
			when "linear" then value = "Bezier.linear"
			when "ease" then value = "Bezier.ease"
			when "ease-in" then value = "Bezier.easeIn"
			when "ease-out" then value = "Bezier.easeOut"
			when "ease-in-out" then value = "Bezier.easeInOut"
			when "spring" then value = "Spring"
		@curveProperty.value = value

	curveSelectionChanged: (value) =>
		if value is "spring"
			@widgetRow.widget.factor = 0.5
			@dampingRatio.enable()
			@timeRow.enable()
			@springChanged()
		else
			@widgetRow.widget.factor = 1
			@dampingRatio.disable()
			@timeRow.enable()
			@updateCurveProperty(value)
			@updateWidget()

	updateWidget: ->
		options = {}
		time = @timeProperty.value ? @timeProperty.default
		if time?
			options.time = time

		curve = @curveSelectionProperty.value ? @curveSelectionProperty.default

		if curve is "spring"
			animator = @springProperty.func(options)
		else
			animator = Framer.Curves.fromString(curve)?(options)

		if @curveProperty.settings.disabled
			animator = null
		animator?.options.tolerance = 1 / 100
		@widgetRow.widget.render(animator, @timeProperty.value)
