(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	factory((global.sourcemapCodec = {}));
}(this, function (exports) { 'use strict';

	var charToInteger = {};
	var integerToChar = {};

	'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/='.split( '' ).forEach( function ( char, i ) {
		charToInteger[ char ] = i;
		integerToChar[ i ] = char;
	});

	function decode$1 ( string ) {
		var result = [],
			len = string.length,
			i,
			hasContinuationBit,
			shift = 0,
			value = 0,
			integer,
			shouldNegate;

		for ( i = 0; i < len; i += 1 ) {
			integer = charToInteger[ string[i] ];

			if ( integer === undefined ) {
				throw new Error( 'Invalid character (' + string[i] + ')' );
			}

			hasContinuationBit = integer & 32;

			integer &= 31;
			value += integer << shift;

			if ( hasContinuationBit ) {
				shift += 5;
			} else {
				shouldNegate = value & 1;
				value >>= 1;

				result.push( shouldNegate ? -value : value );

				// reset
				value = shift = 0;
			}
		}

		return result;
	}

	function encode$1 ( value ) {
		var result, i;

		if ( typeof value === 'number' ) {
			result = encodeInteger( value );
		} else {
			result = '';
			for ( i = 0; i < value.length; i += 1 ) {
				result += encodeInteger( value[i] );
			}
		}

		return result;
	}

	function encodeInteger ( num ) {
		var result = '', clamped;

		if ( num < 0 ) {
			num = ( -num << 1 ) | 1;
		} else {
			num <<= 1;
		}

		do {
			clamped = num & 31;
			num >>= 5;

			if ( num > 0 ) {
				clamped |= 32;
			}

			result += integerToChar[ clamped ];
		} while ( num > 0 );

		return result;
	}

	function decodeSegments(encodedSegments) {
		var i = encodedSegments.length;
		var segments = new Array(i);

		while (i--) {
			segments[i] = decode$1(encodedSegments[i]);
		}return segments;
	}

	function decode(mappings) {
		var sourceFileIndex = 0; // second field
		var sourceCodeLine = 0; // third field
		var sourceCodeColumn = 0; // fourth field
		var nameIndex = 0; // fifth field

		var lines = mappings.split(';');
		var numLines = lines.length;
		var decoded = new Array(numLines);

		var i = undefined;
		var j = undefined;
		var line = undefined;
		var generatedCodeColumn = undefined;
		var decodedLine = undefined;
		var segments = undefined;
		var segment = undefined;
		var result = undefined;

		for (i = 0; i < numLines; i += 1) {
			line = lines[i];

			generatedCodeColumn = 0; // first field - reset each time
			decodedLine = [];

			segments = decodeSegments(line.split(','));

			for (j = 0; j < segments.length; j += 1) {
				segment = segments[j];

				if (!segment.length) {
					break;
				}

				generatedCodeColumn += segment[0];

				result = [generatedCodeColumn];
				decodedLine.push(result);

				if (segment.length === 1) {
					// only one field!
					continue;
				}

				sourceFileIndex += segment[1];
				sourceCodeLine += segment[2];
				sourceCodeColumn += segment[3];

				result.push(sourceFileIndex, sourceCodeLine, sourceCodeColumn);

				if (segment.length === 5) {
					nameIndex += segment[4];
					result.push(nameIndex);
				}
			}

			decoded[i] = decodedLine;
		}

		return decoded;
	}

	function encode(decoded) {
		var offsets = {
			generatedCodeColumn: 0,
			sourceFileIndex: 0, // second field
			sourceCodeLine: 0, // third field
			sourceCodeColumn: 0, // fourth field
			nameIndex: 0 // fifth field
		};

		return decoded.map(function (line) {
			offsets.generatedCodeColumn = 0; // first field - reset each time
			return line.map(encodeSegment).join(',');
		}).join(';');

		function encodeSegment(segment) {
			if (!segment.length) {
				return segment;
			}

			var result = new Array(segment.length);

			result[0] = segment[0] - offsets.generatedCodeColumn;
			offsets.generatedCodeColumn = segment[0];

			if (segment.length === 1) {
				// only one field!
				return encode$1(result);
			}

			result[1] = segment[1] - offsets.sourceFileIndex;
			result[2] = segment[2] - offsets.sourceCodeLine;
			result[3] = segment[3] - offsets.sourceCodeColumn;

			offsets.sourceFileIndex = segment[1];
			offsets.sourceCodeLine = segment[2];
			offsets.sourceCodeColumn = segment[3];

			if (segment.length === 5) {
				result[4] = segment[4] - offsets.nameIndex;
				offsets.nameIndex = segment[4];
			}

			return encode$1(result);
		}
	}

	exports.decode = decode;
	exports.encode = encode;

}));
//# sourceMappingURL=sourcemap-codec.umd.js.map