#!/usr/bin/env python
# encoding: utf-8

import sys
import os
import logging
import time
import threading
import socket
import traceback
import random
import json
import urllib2
# import atexit

logging.basicConfig(level=logging.DEBUG, format="%(message)s")

def main():

	exit_without_process(os.environ.get("PARENT_PROCESS", None), interval=10)
	cleanup_system_path()
	
	from server import FramerServerApp

	port = get_open_port(8000)
	server = FramerServerApp(port=port)

	# urllib2 does not work with proxies out of the box :S
	proxy_support = urllib2.ProxyHandler({})
	opener = urllib2.build_opener(proxy_support)
	urllib2.install_opener(opener)

	def ready_handler():
		logging.info(json.dumps({"signal": "ready", "url": server.url}))
		logging.info("Server ready at: %s", server.url)

	wait_for_http_ready("http://127.0.0.1:{0}/_server/api/ping".format(port), ready_handler)

	try:
		server.start()
	except Exception, e:
		logging.error("\n".join(traceback.format_exception(*sys.exc_info())))


def cleanup_system_path():

	sys_path = []

	for path in sys.path:
		if "site-packages" not in path:
			sys_path.append(path)

	sys.path = sys_path

	sys.path.insert(0, os.path.join(os.path.dirname(__file__), 'vendor/packages.zip'))
	sys.path.insert(0, os.path.join(os.path.dirname(__file__), 'vendor/'))
	sys.path.insert(0, os.path.join(os.path.dirname(__file__), 'webserver/'))

def is_process_running(pid):
	try:
		os.kill(pid, 0)
		return True
	except OSError:
		return False

def exit_without_process(pid, interval=1):

	if not pid:
		return

	pid = int(pid)
	
	def check():
		while is_process_running(pid):
			time.sleep(interval)
			
		os.kill(os.getpid(), 9)
	
	thread = threading.Thread(target=check)
	thread.daemon = True
	thread.start()

def is_port_open(port, host="127.0.0.1"):
 
	s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
	s.settimeout(0.5)
 
	try:
		s.connect((host, int(port)))
		s.shutdown(2)
		return False
	except Exception, e:
		return True

def get_open_port(start, limit=25):
	
	for port in xrange(start, start+limit):
		if is_port_open(port):
			return port

	raise Exception("Could not find open port from %s", start)

def wait_for_http_ready(url, handler, interval=0.1):
	
	def test():
		try:
			urllib2.urlopen(url).code == 200
		except Exception, e:
			print "Waiting for startup", e
			return False

	def check():
		while test() is False:
			time.sleep(interval)
			
		handler()
	
	thread = threading.Thread(target=check)
	thread.daemon = True
	thread.start()

if __name__ == "__main__":
	main()
