propertyEqual = (a, b) ->
	if a instanceof Color
		return a.isEqual(b)
	else
		return _.isEqual(a, b)


ViewerTools = class exports.ViewerTools

		@getLayers: -> Framer.CurrentContext._layers or Framer.CurrentContext._layerList

		@getLayerById: (id) ->

			return unless id?

			layers = @getLayers()
			return if not layers?

			for layer in layers
				return layer if layer?.id is id

			return

		@getAllLayersWithHash: (hash) ->
			return [] unless hash?
			layers = @getLayers()?.filter (layer) ->
					return layer?.__framerInstanceInfo?.hash is hash or hash is "#il|#{layer.__framerImportedFromPath}|#{layer.name}"
			return layers ? []

		@getLayersWithHashes: (hashes) ->
			layers = []
			return layers unless hashes?
			for hash in hashes
				layers = layers.concat @getAllLayersWithHash(hash)
			return layers

		@getLayersForTarget: (editingTarget) ->
			return [] unless editingTarget?
			hashes = _.clone(editingTarget.relatedHashes)
			if editingTarget.owner?
				hashes.push(editingTarget.owner)
			layers = @getLayersWithHashes(hashes)
			lookupLayers = @lookupLayers(editingTarget.relatedLookup)
			layers.concat(lookupLayers)

		@firstLayerForTarget: (editingTarget) ->
			_.first(@getLayersForTarget(editingTarget))

		@lookupLayers: (info) ->
			return [] unless info?.source? and info?.keyPath? and _.isArray(info?.keyPath)
			sourceLayer = _.first(@getAllLayersWithHash(info.source))
			return result unless sourceLayer?
			result = sourceLayer
			for key in info.keyPath
				result = result[key]
			return [] unless _.isArray(result)
			return result.filter (layer) -> layer instanceof Layer

		@distinctPropertiesOfLayers: (layers) ->
			keyDiffs = []
			firstLayer = _.head(layers)
			return keyDiffs unless firstLayer?
			values = firstLayer.props
			for layer in layers
				for key, value of values
					if key == "ignoreEvents"
						continue
					if not propertyEqual(layer.props[key], values[key]) and not (key in keyDiffs)
						keyDiffs.push(key)
			return keyDiffs

		@removeQuotes: (value) ->
			regex = /^['"](.+(?=['"]$))["']$/
			if regex.test(value)
				result = value.replace(regex, '$1')
			else
				result = value
			result
