class exports.Transform

    @getLayerScreenFrame: (target) ->

        layers = target.superLayers(context = true)
        layers.reverse()
        layers.push(target)

        scaleX = 1
        scaleY = 1

        x = 0
        y = 0

        for layer in layers

            localScaleX = layer.scale * layer.scaleX
            localScaleY = layer.scale * layer.scaleY

            x += (layer.x + (1 - localScaleX) * layer.originX * layer.width) * scaleX
            y += (layer.y + (1 - localScaleY) * layer.originY * layer.height) * scaleY

            scaleX *= localScaleX
            scaleY *= localScaleY

        frame =
            x: x
            y: y
            width: target.width * scaleX
            height: target.height * scaleY

    @screenFrameToLayer: (frame, target) ->

        layers = target.superLayers(context = true)
        layers.reverse()

        scaleX = 1
        scaleY = 1

        x = 0
        y = 0

        for layer in layers
            localScaleX = layer.scale * layer.scaleX
            localScaleY = layer.scale * layer.scaleY

            x += (layer.x + (1 - localScaleX) * layer.originX * layer.width) * scaleX
            y += (layer.y + (1 - localScaleY) * layer.originY * layer.height) * scaleY

            scaleX *= localScaleX
            scaleY *= localScaleY

        localScaleX = target.scale * target.scaleX
        localScaleY = target.scale * target.scaleY

        frame.width		/= (scaleX * localScaleX)
        frame.height 	/= (scaleY * localScaleY)

        x += ((1 - localScaleX) * target.originX * frame.width) * scaleX
        y += ((1 - localScaleY) * target.originY * frame.height) * scaleY

        frame.x = (frame.x - x) / scaleX
        frame.y = (frame.y - y) / scaleY

        target.frame = Utils.pixelAlignedFrame frame
