class exports.SVGLayer extends Layer

	constructor: (options = {}) ->

		options = _.defaults options,
			strokeWidth: 1
			stroke: "#eeca00"
			backgroundColor: null
			clip: false
			fill: "transparent"
			linecap: "square"
			index: 2

		super options

	addLine: (pointA, pointB) =>

		path = "'M#{pointA.x},#{pointA.y} #{pointB.x},#{pointB.y}'"
		svg = "<svg overflow='visible' style='position:absolute;' width='#{@width}px' height='#{@height}px' xmlns='http://www.w3.org/2000/svg' version='1.1'><path d=#{path} #{@rendering([pointA, pointB])} /></svg>"
		@html = @html + svg

	addPolyline: (points, holePoints) =>

		path = "'M"
		
		for point, index in points
			path += "#{point.x},#{point.y}"
			path += "L" unless index + 1 is points.length

		if holePoints and holePoints.length > 0
			path += "ZM"
			for point, index in holePoints
				path += "#{point.x},#{point.y}"
				path += "L" unless index + 1 is holePoints.length

		path += "z'"
		svg = "<svg overflow='visible' style='position:absolute;' width='#{@width}px' height='#{@height}px' xmlns='http://www.w3.org/2000/svg' version='1.1'><path d=#{path} #{@rendering(points)} /></svg>"
		@html = @html + svg

	addCircle: (centerPoint, radius) =>

		circle = "<circle cx='#{centerPoint.x}' cy='#{centerPoint.y}' r='#{radius}' />"
		svg = "<svg overflow='visible' style='position:absolute;' width='#{@width}px' height='#{@height}px' xmlns='http://www.w3.org/2000/svg' version='1.1'>#{circle}</svg>"
		@html += svg

	addArc: (centerPoint, radius, startAngle, endAngle) =>

		offset = Math.PI / 2
		startRadian = (Math.PI * startAngle / 180) - offset
		endRadian = (Math.PI * (endAngle - startAngle) / 180) - offset
		bigArc = 0
		bigArc = 1 if Math.abs(startRadian - endRadian) > Math.PI

		x1 = Math.round(centerPoint.x + radius * Math.cos(startRadian))
		y1 = Math.round(centerPoint.y + radius * Math.sin(startRadian))

		x2 = Math.round(centerPoint.x + radius * Math.cos(endRadian))
		y2 = Math.round(centerPoint.y + radius * Math.sin(endRadian))

		# 1 means clockwise

		clockwise = 1
		clockwise = 0 if endAngle < startAngle

		path = "'M#{centerPoint.x},#{centerPoint.y}  L" + x1 + "," + y1 + "  A#{radius},#{radius} 0 #{bigArc},#{clockwise} " + x2 + "," + y2 + " z'"

		svg = "<svg overflow='visible' style='position:absolute;' width='#{@width}px' height='#{@height}px' xmlns='http://www.w3.org/2000/svg' version='1.1'><path d=#{path} /></svg>"
		@html += svg

	clear: ->
		@html = ""

	@define "linecap",
		get: -> @style.strokeLinecap
		set: (value) ->
			@style.strokeLinecap = value

	@define "strokeLinecap",
		get: -> @style.strokeLinecap
		set: (value) ->
			@style.strokeLinecap = value

	@define "fill",
		get: -> @style.fill
		set: (value) ->
			if value == null
				value = "transparent"
			@style.fill = value

	@define "stroke",
		get: -> @style.stroke
		set: (value) -> @style.stroke = value

	@define "strokeColor",
		get: -> @style.stroke
		set: (value) -> @style.stroke = value

	@define "strokeWidth",
		get: -> Number(@style.strokeWidth.replace(/[^\d.-]/g, ''))
		set: (value) ->
			@style.strokeWidth = value

	rendering: (points) =>
		return "shape-rendering='crispEdges'" if @straightLine(points)
		return ""

	@define "dashArray",
		get: -> @style.strokeDasharray
		set: (value) ->
			@style.strokeDasharray = value

	@define "dashOffset",
		get: -> @style.strokeDashoffset
		set: (value) ->
			@style.strokeDashoffset = value

	straightLine: (points) ->

		prevPoint = null
		for point in points
			if prevPoint
				return false if prevPoint.x isnt point.x and prevPoint.y isnt point.y
			prevPoint = point
		return true
			