{Transform}		= require "./../tools/Transform"
{TooltipLayer}  = require "./../edit/tooltip/TooltipLayer"

highlightColor = "#48CFFF"

ANIMATING_KEYS = ["x", "y", "width", "height", "scaleX", "scaleY", "scaleZ", "scale", "rotation", "rotationX", "rotationY", "rotationZ", "skew", "skewX", "skewY"]

CONFIG =
	borderWidth: 1

class exports.HighlightComponent
	constructor: ->
		ctx = new Framer.Context name:"Highlight"
		ctx.run =>
			@layer = new Layer
			@tooltip = new TooltipLayer

		@layer.style =
			border: "#{CONFIG.borderWidth}px solid #{highlightColor}"
			zIndex:10000
		@layer.backgroundColor = "rgba(40,175,250,0.2)"

		@layer.visible = false
		@tooltip.visible = false

		@unhighlight()

	highlight: (layer, showInfo = true) =>
		return if @current is layer
		@showInfo = showInfo
		@current = layer
		@update()
		for p in ANIMATING_KEYS
			@current.on("change:#{p}", @update)

	unhighlight: ->
		return unless @current
		for p in ANIMATING_KEYS
			@current.off("change:#{p}", @update)
		@current = null
		@layer.visible = false
		@tooltip.visible = false

	update: =>
		return unless @layer
		return unless @current

		# check if the Framer version supports bounding frames for a more precise result
		if Utils.boundingFrame
			currentFrame = Utils.boundingFrame(@current, true)
			screenFrame = Utils.boundingFrame(@current, false)
			properties =
				"x": screenFrame.x
				"y": screenFrame.y
				"width": screenFrame.width
				"height": screenFrame.height
			@tooltip.showProperties(properties)
		else
			currentFrame = Transform.getLayerScreenFrame(@current)
			@layer.rotation = @current.rotation
			properties =
				"x": @current.x.toFixed(1)
				"y": @current.y.toFixed(1)
				"width": @current.width.toFixed(1)
				"height": @current.height.toFixed(1)
			@tooltip.showProperties(properties)

		currentFrame.x -= CONFIG.borderWidth
		currentFrame.y -= CONFIG.borderWidth
		currentFrame.width  += 2 * CONFIG.borderWidth
		currentFrame.height += 2 * CONFIG.borderWidth

		@layer.backgroundColor = if @showInfo then "rgba(40,175,250,0.2)" else null
		@layer.visible = true
		@layer.frame = currentFrame

		canvasFrame = Framer.Canvas?.frame

		if not canvasFrame
			canvasFrame =
				width:  Screen.width
				height: Screen.height

		margin = 12

		@tooltip.visible = @showInfo
		return if not @showInfo

		midYPos = @layer.midY
		midXPos = @layer.midX
		infoOnTopOrBottom = true

		if @layer.y < canvasFrame.height - (@tooltip.height + margin) && @layer.maxY > (@tooltip.height + margin)
			if midXPos > canvasFrame.width - ((@tooltip.width / 2) + margin)
				@tooltip.maxX = Math.min(@layer.x - margin, canvasFrame.width - margin)
				infoOnTopOrBottom = false
			else if midXPos < ((@tooltip.width / 2) + margin)
				@tooltip.x = Math.max(@layer.maxX + margin, margin)
				infoOnTopOrBottom = false
			if !infoOnTopOrBottom
				@tooltip.midY = Math.max(Math.min(midYPos, canvasFrame.height - ((@tooltip.height + margin) - margin) ), (@tooltip.height + margin) - margin)

		if infoOnTopOrBottom
			yPos = @layer.maxY + margin

			if yPos > canvasFrame.height - (@tooltip.height + margin)
				yPos = @layer.y - (@tooltip.height + margin)
				if yPos > canvasFrame.height - (@tooltip.height + margin)
					yPos = canvasFrame.height - (@tooltip.height + margin)
			else if yPos < margin
					yPos = margin

			if midXPos > canvasFrame.width - ((@tooltip.width / 2) + margin)
				midXPos = canvasFrame.width - ((@tooltip.width / 2) + margin)

			else if midXPos < ((@tooltip.width / 2) + margin)
				midXPos = ((@tooltip.width / 2) + margin)

			@tooltip.midX = midXPos
			@tooltip.y = yPos

		@tooltip.x = Math.max(margin, @tooltip.x)
		@tooltip.maxX = Math.min(canvasFrame.width - margin, @tooltip.maxX)
		@tooltip.y = Math.max(margin, @tooltip.y)
		@tooltip.maxY = Math.min(canvasFrame.height - margin, @tooltip.maxY)
		@tooltip.pixelAlign()
