{EditStates} 			= require "./../EditStates"
{TransformStates} 		= require "./../transform/TransformStates"
{OriginHandle} 			= require "./OriginHandle"
{BorderRadiusHandle} 	= require "./BorderRadiusHandle"
{AnimationControl}          = require "./AnimationControl"

class exports.ViewController

	constructor: (editor, dragHandles, animationControlActions) ->
		@ctx = new Framer.Context name: "ViewController"
		@editor = editor
		@handles = dragHandles
		@animationControlActions = animationControlActions
		@loadView()

	loadView: ->
		@ctx.run =>
			unless @animationControl?
				@animationControl = new AnimationControl @animationControlActions
				@animationControl.visible = false

	render: (activeHandle) =>
		@ctx.run =>
			for handle in @handles
				unless handle.dragLayer?
					handle.dragLayer = new Layer
						size: 6
						borderRadius: 3
						backgroundColor: "white"
						index: 3
						shadowColor: "rgba(0,0,0,0.5)"
						shadowSpread: 1
					handle.dragLayer.states =
						originSnap:
							size: 4
							backgroundColor: "black"
							shadowColor: "rgba(255,255,255,0.5)"
						locked:
							size: 6
							backgroundColor: "rgba(255,255,255,0.5)"
							shadowColor: "rgba(0,0,0,0.25)"

				dragLayer = handle.dragLayer

				switch @editor.state
					when EditStates.transform
						dragLayer.stateSwitch("originSnap")
						transformState = @editor.transformController.state
						dragLayer.visible = transformState is TransformStates.origin or (@origin? and @origin.isActive and transformState isnt TransformStates.scaling)
					when EditStates.rotating, EditStates.borderRadius
						dragLayer.visible = false
						continue
					when EditStates.animation
						dragLayer.visible = false
					when EditStates.hidden
						dragLayer.visible = false
					else
						if @editor.propertyLock.resizingHandle(handle)
							dragLayer.stateSwitch("locked")
						else
							dragLayer.stateSwitch("default")

						dragLayer.visible = handle.isActive
						dragLayer.visible = handle is activeHandle if activeHandle?

				dragLayer.midX = handle.x
				dragLayer.midY = handle.y

			unless @borderRadiusHandle?
				@borderRadiusHandle = new BorderRadiusHandle(dragHandle:@handles[0])
				@borderRadiusHandle.updatePosition()
			@borderRadiusHandle.updateMousePos(@editor.mouse)
			@borderRadiusHandle.visible = ((@editor.state is EditStates.idle or @editor.state is EditStates.locked) and @borderRadiusHandle.isActive) or @editor.state is EditStates.borderRadius
			if @editor.propertyLock.borderRadius()
				@borderRadiusHandle.stateSwitch("locked")
			else if @borderRadiusHandle.inDragDistance()
				@borderRadiusHandle.stateSwitch("active")
			else
				@borderRadiusHandle.stateSwitch("normal")

			@scaleRing ?= new Layer
				backgroundColor: "rgba(255,255,255,.12)"
				borderRadius: 1000000
				borderColor: "rgba(0,0,0,.4)"
				borderWidth: 1
				size: 180
			@scaleRing.visible = false

			@origin ?= new OriginHandle
			@origin.layer = @editor.layer
			@origin.updatePosition()

			if @origin.distance and @editor.mouse?
				@scaleRing.size = @origin.distance * 2
			else
				@scaleRing.size = 1
			@scaleRing.midX = @origin.midX
			@scaleRing.midY = @origin.midY

			switch @editor.state
				when EditStates.transform
					@origin.visible = true
					switch @editor.transformController.state
						when TransformStates.scaling
							@origin.stateSwitch("scaling")
							@scaleRing.visible = true
						else
							if @origin.isActive
								@origin.stateSwitch("active")
								@scaleRing.visible = false
							else
								@origin.stateSwitch("default")
								@scaleRing.visible = true
				when EditStates.rotating
					@origin.visible = true
					@origin.stateSwitch("default")
				else
					@origin.visible = false

			switch @editor.state
				when EditStates.animation
					@animationControl.visible = true
					@animationControl.play.active = not @editor.animationTool.isPlaying
					@animationControl.looping.active = @editor.animationTool.isLooping
					@animationControl.slomo.active = @editor.animationTool.isSlomo
				else
					@animationControl.visible = false

	end: =>
		@ctx.run =>
			for handle in @handles
				dragLayer = handle.dragLayer
				continue unless dragLayer?
				dragLayer.visible = false
			@borderRadiusHandle?.visible = false
			@origin?.visible = false
			@scaleRing?.visible = false
