class exports.OriginHandle extends Layer

	constructor: (options = {}) ->
		options = _.defaults options,
			size: 10
			backgroundColor: "white"
			borderRadius: 100
			shadowColor: "rgba(0,0,0,0.5)"
			shadowSpread: 1
		super options

		@states =
			active:
				size: 12
				borderColor: "white"
				backgroundColor: "rgba(0,0,0,.5)"
				shadowColor: "rgba(255,255,255,0.5)"
			scaling:
				size: 6
				borderWidth: 1
				backgroundColor: "white"
				shadowColor: "rgba(0,0,0,0.5)"

		@on Events.StateDidSwitch, @position

	@define "centerPoint",
		set: (value) ->
			@_centerPoint = value
			@position()
		get: -> return @_centerPoint

	updatePosition: =>
		return unless @layer?
		layerOrigin = {x: @layer.width * @layer.originX, y: @layer.height * @layer.originY}
		@centerPoint = Utils.convertPointToContext(layerOrigin, @layer, true, true)

	position: =>
		@midX = @centerPoint.x
		@midY = @centerPoint.y

	inDragDistance: =>
		return @distance < 14 if @distance?
		return false

	updateMousePos: (mouse) =>
		return @_distance = null unless mouse?
		@_distance = Utils.pointDistance(@centerPoint, mouse)
		return @distance

	@define "distance",
		get: ->
			return @_distance if @_distance?
			return null

	@define "isActive",
		get: ->
			return @inDragDistance()
