class exports.DragHandle extends Framer.BaseClass

	constructor: (options) ->
		@fx = options.fx
		@fy = options.fy
		@index = options.index

	attachToLayer: (layer) =>
		@layer = layer

	updatePosition: =>
		return unless @layer?
		point = Utils.convertPointToContext({x:@fx * @layer.width, y:@fy * @layer.height}, @layer, true, true)
		@_x = point.x
		@_y = point.y
		@_distance = null

	updateMousePos: (mouse) =>
		@_distance = Utils.pointDistance(mouse, @point)
		return @distance

	inDragDistance: (mouse) =>
		@updateMousePos(mouse) if mouse?
		return false if @fx is 0.5 and @fy is 0.5
		return @distance < 9 if @distance?
		return false

	inRotateDistance: =>
		return false if @fx is 0.5 and @fy is 0.5
		return @distance < 16 if @distance?
		return false

	originSnap: (mouse) =>
		distance = Utils.pointDistance(@point, mouse)
		return null unless distance < 10
		return {originX:@fx, originY:@fy}

	neighborHandles: =>
		result = []
		return result if @fx is 0.5 and @fy is 0.5

		if @fx is 0.5

			leftNeighborIndex = @index - 3
			rightNeighborIndex = @index + 3

		else if @fy is 0.5

			leftNeighborIndex = @index - 1
			rightNeighborIndex = @index + 1

		else

			leftNeighborIndex = @index + 3 if @fx is 0
			leftNeighborIndex = @index - 3 if @fx is 1

			rightNeighborIndex = @index + 1 if @fy is 0
			rightNeighborIndex = @index - 1 if @fy is 1

		result.push(@handles[leftNeighborIndex])
		result.push(@handles[rightNeighborIndex])

		return result

	centerHandle: => return @handles[4]

	oppositeHandle: =>
		if @fx is 0
			return @handles[6] if @fy is 1
			return @handles[7] if @fy is 0.5
			return @handles[8] if @fy is 0
		if @fx is 0.5
			return @handles[3] if @fy is 1
			return @handles[5] if @fy is 0
		if @fx is 1
			return @handles[0] if @fy is 1
			return @handles[1] if @fy is 0.5
			return @handles[2] if @fy is 0

	neighborDistances: =>
		distances = []
		for neighbor in @neighborHandles()
			distance = Utils.pointDistance(neighbor, @point)
			distances.push(distance)
		return distances

	@define "x",
		get: -> return @_x or 0

	@define "y",
		get: -> return @_y or 0

	@define "point",
		get: -> return {x: @x, y: @y}

	@define "distance",
		get: ->
			return @_distance if @_distance?
			return null

	@define "isActive",
		get: ->
			return false if @fy is 0.5 and @fx is 0.5
			return true unless @fy is 0.5 or @fx is 0.5
			neighborDistances = @neighborDistances()
			return 14 < _.min(neighborDistances) if neighborDistances and neighborDistances.length > 0
			return true
