{EditStates} = require "./../EditStates"
{TransformStates} = require "./../transform/TransformStates"

rotationCursors = [
	"rotateTopMid",
	"rotateTopRight",
	"rotateMidRight",
	"rotateBottomRight",
	"rotateBottomMid",
	"rotateBottomLeft",
	"rotateMidLeft",
	"rotateTopLeft"
]

resizingCursors = [
	"resizeVertical",
	"resizeDiagonalRight",
	"resizeHorizontal",
	"resizeDiagonalLeft"
]

class exports.CursorController

	show:(editor) =>
		switch editor.state
			when EditStates.resizing
				activeHandle = editor.viewController.activeHandle
				@showResizingCursor(editor.centerPoint, activeHandle) if activeHandle?
			when EditStates.rotating
				@showRotationCursor(editor.origin, editor.mouse)
			when EditStates.locked
				@showLock()
			when EditStates.transform
				switch editor.transformController.state
					when TransformStates.scaling
						@showScaleCursor(editor.origin, editor.mouse)
					when TransformStates.idle
						return
					when TransformStates.locked
						@showLock()
					else
						@remove()
			else
				@remove()

	showResizingCursor: (centerPoint, handle) =>
		return if handle.fx is 0.5 and handle.fy is 0.5
		
		if handle.fx is 0.5 or handle.fy is 0.5
			index = @circleAngle(centerPoint, handle.point)
		else
			left = handle.neighborHandles()[0]
			right = handle.neighborHandles()[1]
			lIndex = @circleAngle(centerPoint, left.point)
			rIndex = @circleAngle(centerPoint, right.point)
			smallest = Math.min(lIndex, rIndex)
			largest = Math.max(lIndex, rIndex)
			index = largest - 1
			index = largest + 1 if largest - smallest > 2

		index = index % 4
		cursorClass = resizingCursors[index]
		@showCursor(cursorClass)

	showScaleCursor: (centerPoint, mouse) =>
		index = @circleAngle(centerPoint, mouse) % 4
		cursorClass = resizingCursors[index]
		@showCursor(cursorClass)

	showRotationCursor: (origin, mouse) =>
		index = @circleAngle(origin, mouse)
		cursorClass = rotationCursors[index]
		@showCursor(cursorClass)

	showLock: =>
		@showCursor("locked")

	circleAngle: (center, point) =>
		angle = Math.atan2(center.y - point.y, center.x - point.x)
		angle = (angle * 180 / Math.PI) - 67.5
		angle += 360 if angle < 0
		return Math.floor(angle / 45)

	showCursor: (cursor) =>
		unless @activeCursor is cursor
			@remove()
			document.body.classList.add(cursor)
			@activeCursor = cursor

	remove: =>
		document.body.classList.remove(@activeCursor) if @activeCursor?
		@activeCursor = null
