class Button extends Layer
	@define 'active',
		get: -> @_active
		set: (active) ->
			if @inactiveImageLayer?
				@imageLayer.visible = active
				@inactiveImageLayer.visible = !active
			else
				@imageLayer?.opacity = if active then 1 else 0.5

			@_active = active

	constructor: (options) ->
		if options.imageLayer?
			@imageLayer = options.imageLayer
		if options.inactiveImageLayer?
			@inactiveImageLayer = options.inactiveImageLayer

		super _.defaults options,
			width: 24
			height: 24
			active: true
			backgroundColor: null
			color: '#fff'

		if @imageLayer?
			@addSubLayer @imageLayer
			@imageLayer.center()
			@imageLayer.pixelAlign()
		if @inactiveImageLayer?
			@addSubLayer @inactiveImageLayer
			@inactiveImageLayer.center()
			@inactiveImageLayer.pixelAlign()

class exports.AnimationControl extends Layer
	constructor: (options) ->
		margin = 30
		super _.defaults options,
			backgroundColor: 'rgba(0,0,0,0.8)'
			borderRadius: 4
			shadowY: 1
			shadowBlur: 4
			shadowColor: 'rgba(0,0,0,0.5)'
			width: 120
			height: 40
			clip: true
			flat: true
			ignoreEvents: false
			x: Align.center()
			y: Align.bottom(-margin)

		@style["-webkit-backdrop-filter"] = "blur(15px)"

		window.onresize = =>
			@x = window.innerWidth / 2 - @width / 2
			@y = window.innerHeight - @height - margin
			@pixelAlign()

		@options =
			curve: "spring"

		@play = new Button
			parent: @
			y: Align.center
			x: Align.center
			clip: false
			imageLayer: new Layer
				name: "play"
				width: 14
				height: 16
				html: '<svg><polygon fill="#FFF" points="0 0 0 16 14 8"></polygon></svg>'
				backgroundColor: 'transparent'
			inactiveImageLayer: new Layer
				name: "stop"
				width: 14
				height: 14
				html: '<svg><rect fill="#FFF" width="14" height="14"></rect></svg>'
				backgroundColor: 'transparent'

		@looping = new Button
			parent: @
			y: Align.center
			x: 10
			imageLayer: new Layer
				width: 12
				height: 18
				backgroundColor: 'transparent'
				html: '<svg><path d="M5,14.9168497 C5.32520847,14.9715299 5.65928779,15 6,15 C9.30696577,15 12,12.3137085 12,9 C12,8.65939681 11.9715035,8.32530628 11.9167601,8 L10.8996556,8 C10.9654555,8.32322428 11,8.6576647 11,9 C11,11.7614237 8.75580481,14 6,14 C5.65753416,14 5.32310994,13.9654833 5,13.8997548 L5,11 L0.5,14.5 L5,18 L5,14.9168497 Z M0.0832399236,10 C0.0284964761,9.67469372 0,9.34060319 0,9 C0,5.6862915 2.69303423,3 6,3 C6.34071221,3 6.67479153,3.02847008 7,3.0831503 L7,4.10024523 C6.67689006,4.03451668 6.34246584,4 6,4 C3.24419519,4 1,6.23857625 1,9 C1,9.3423353 1.03454445,9.67677572 1.10034441,10 L0.0832399236,10 Z M7,0 L7,7 L11.5,3.5 L7,0 Z" stroke="none" fill="#FFF"></path></svg>'
				y: Align.center
				opacity: 0.5
				rotation: 90
			active: false

		@slomo = new Button
			parent: @
			y: Align.center
			x: @play.maxX + 12
			active: false
			imageLayer: new Layer
				width: 15
				height: 15
				html: '<svg><path d="M7.5,15 C11.6421356,15 15,11.6421356 15,7.5 C15,3.35786438 11.6421356,0 7.5,0 C3.35786438,0 0,3.35786438 0,7.5 C0,11.6421356 3.35786438,15 7.5,15 Z M7.5,14 C11.0898509,14 14,11.0898509 14,7.5 C14,3.91014913 11.0898509,1 7.5,1 C3.91014913,1 1,3.91014913 1,7.5 C1,11.0898509 3.91014913,14 7.5,14 Z M8,7 L10,7 L10,8 L8,8 L8,7 Z M7,3 L8,3 L8,8 L7,8 L7,3 Z" stroke="none" fill="#FFF" fill-rule="evenodd"></path></svg>'
				backgroundColor: 'transparent'
				opacity: 0.5

		@play.onClick options?.clickedPlay
		@looping.onClick options?.clickedLooping
		@slomo.onClick options?.clickedSlomo
