class exports.OriginTool

	start: (editor) =>
		@mouseStart = editor.mouse
		@startPoint = editor.layer.point
		@originStart = {x:editor.layer.originX, y:editor.layer.originY}
		@offset = {x:@mouseStart.x - editor.origin.x, y:@mouseStart.y - editor.origin.y}
		editor.viewController.render()

	end: (editor) => @mouseStart = @originStart = @startPoint = @offset = null

	handleMouseMove: (event, editor) =>

		layer = editor.layer
		mouse = editor.mouse
		originHandle = editor.viewController.origin

		layer.originX = @originStart.x
		layer.originY = @originStart.y
		layer.point = @startPoint

		originOffset = Utils.pointSubtract(mouse, @offset)

		for handle in editor.resizeHandles
			snapSucces = handle.originSnap(originOffset)
			break if snapSucces?

		if snapSucces?
			{originX, originY} = snapSucces
		else
			dX = mouse.x - @mouseStart.x
			dY = mouse.y - @mouseStart.y

			originStart =
				x: layer.width * @originStart.x
				y: layer.height * @originStart.y

			originContext = Utils.convertPointToContext(originStart, layer, true, true)
			originContext.x += dX
			originContext.y += dY
			ptInLayer = Utils.convertPointFromContext(originContext, layer, true, true)
			originX = ptInLayer.x / layer.width
			originY = ptInLayer.y / layer.height
			originX = Math.round(originX * 100) / 100
			originY = Math.round(originY * 100) / 100

		topInSuperBefore = Utils.convertPoint({}, layer, layer.superLayer)

		layer.originX = originX
		layer.originY = originY
		
		topInSuperAfter = Utils.convertPoint({}, layer, layer.superLayer)

		xDiff = topInSuperAfter.x - topInSuperBefore.x
		yDiff = topInSuperAfter.y - topInSuperBefore.y
		layer.x -= xDiff
		layer.y -= yDiff

		originHandle.updatePosition()
