{EditStates}  = 		require "./../EditStates"
{TransformStates} = 	require "./../transform/TransformStates"
{TooltipLayer} = 		require "./TooltipLayer"

class exports.TooltipManager

	constructor: () ->
		@tooltipCtx = new Framer.Context name: "tooltip"

	showInfo: (editor) =>
		layer = editor.layer
		mouse = editor.mouse
		switch editor.state
			when EditStates.moving
				properties =
					x: Math.round(layer.x)
					y: Math.round(layer.y)
			when EditStates.resizing
				properties =
					width: Math.round(layer.width)
					height: Math.round(layer.height)
			when EditStates.rotating
				properties =
					rotation: "#{Math.round(layer.rotation)}&#176;"
			when EditStates.borderRadius
				properties =
					radius: layer.borderRadius
			when EditStates.transform
				switch editor.transformController.state
					when TransformStates.origin
						properties =
							x: layer.originX
							y: layer.originY
					when TransformStates.scaling
						properties =
							scale: layer.scale
		@showText(properties, mouse) if properties?

	showText: (properties, mouse) ->

		mouse = @addOffset(mouse)

		@tooltipCtx.run ->
			@tooltip ?= new TooltipLayer
			@tooltip.showProperties(properties)
			@tooltip.point = mouse

			# constraints
			@tooltip.x = 8 if @tooltip.x < 8
			@tooltip.maxX = Screen.width - 8 if @tooltip.maxX > Screen.width - 8
			@tooltip.y = 8 if @tooltip.y < 8
			@tooltip.maxY = Screen.height - 8 if @tooltip.maxY > Screen.height - 8

	addOffset: (mouse) ->
		return point =
			x: mouse.x + 16
			y: mouse.y + 16

	hide: ->
		@tooltipCtx.run ->
			@tooltip?.visible = false
