class exports.TranslationTool

	start: (editor) =>
		@layerMouseDownPoint = editor.layer.point
		@mouseStart = editor.mouse
		@shiftKeyDown = false
		@lockedX = editor.propertyLock.x()
		@lockedY = editor.propertyLock.y()

	end: (editor) =>
		@layerMouseDownPoint = @mouseStart = null
		@shiftKeyDown = @lockedY = @lockedX = false
		editor.snappingVisualizer.end()

	handleMouseMove: => @update(arguments...)

	handleKeyUp: (event, editor) =>
		if @shiftKeyDown and not event.shiftKey and not editor.propertyLock.x() and not editor.propertyLock.y()
			@shiftKeyDown = @lockedY = @lockedX = false
			@update(arguments...)
			editor.snappingVisualizer.showLayerOutline(editor.layer)
			editor.tooltip.showInfo(editor)
			editor.layerChanged()

	handleKeyDown: (event, editor) =>

		if @layerMouseDownPoint? and editor?
			if event.shiftKey and not @shiftKeyDown and not editor.propertyLock.x() and not editor.propertyLock.y()
				@shiftKeyDown = true
				@update(arguments...)
				editor.layerChanged()
		else
			if event.keyCode in [37..40]

				increment = 1
				increment = 10 if event.shiftKey

				layer = editor.layer

				unless editor.propertyLock.y()
					# up arrow
					layer.y -= increment if event.keyCode is 38
					# down arrow
					layer.y += increment if event.keyCode is 40

				unless editor.propertyLock.x()
					# left arrow
					layer.x -= increment if event.keyCode is 37
					# right arrow
					layer.x += increment if event.keyCode is 39

				editor.layerChanged()
				editor.updateLayerInfo()

	update: (event, editor) =>

		editor.viewController.end()

		layer = editor.layer
		relatedLayers = editor.relatedLayers

		convertedStartPoint = Utils.convertPointFromContext(@mouseStart, layer, true, false)
		convertedDragPoint =  Utils.convertPointFromContext(editor.mouse, layer, true, false)

		moveVector =
			x: convertedDragPoint.x - convertedStartPoint.x
			y: convertedDragPoint.y - convertedStartPoint.y
		layerPoint =
			x: @layerMouseDownPoint.x + moveVector.x
			y: @layerMouseDownPoint.y + moveVector.y

		if event.ctrlKey and event.metaKey

			layer.x = layerPoint.x
			layer.y = layerPoint.y
			editor.snappingVisualizer.end()
		else
			snapResult = editor.snappingModel.moveLayer(layer, relatedLayers, layerPoint)

			if @shiftKeyDown and not @lockedX and not @lockedY
				deltaX = Math.abs(moveVector.x)
				deltaY = Math.abs(moveVector.y)
				@lockedY = deltaX > deltaY
				@lockedX = deltaX <= deltaY

			layer.x = @layerMouseDownPoint.x if @lockedX
			layer.y = @layerMouseDownPoint.y if @lockedY

			snapResult.horizontalCoordinates = [] if @lockedX
			snapResult.verticalCoordinates = [] if @lockedY

			editor.snappingVisualizer.snaps(layer, snapResult.horizontalCoordinates, snapResult.verticalCoordinates)
			if @shiftKeyDown
				editor.snappingVisualizer.showLayerOutline(layer)
				editor.tooltip.showInfo(editor)
