class exports.RotationTool

	start: (editor) =>
		@mouseStart = editor.mouse
		@rotationStart = editor.layer.rotation
		@rotationNormalizer = Utils.rotationNormalizer()
		editor.viewController.render()

	end: (editor) =>
		@mouseStart = null
		@rotationStart = null
		@rotationNormalizer = null

	handleKeyDown: (event, editor) ->
		if event.keyCode == 16
			editor.layerChanged()

	handleKeyUp: (event, editor) ->
		if event.keyCode == 16
			editor.layerChanged()

	handleMouseMove: (event, editor) =>
		layer = editor.layer
		layer.rotation = @calculateRotation(editor,event.shiftKey)

	calculateRotation: (editor,snap) ->
		origin = editor.origin
		mouse = editor.mouse

		angle1 = Math.atan2(@mouseStart.y - origin.y, @mouseStart.x - origin.x)
		angle2 = Math.atan2(mouse.y - origin.y, mouse.x - origin.x)
		angle = angle2 - angle1
		angle = angle * 180 / Math.PI

		rotation = @rotationStart + angle
		rotation = Math.round(@rotationNormalizer(rotation))
		if snap
			# rest = rotation % 15
			times = Math.round(rotation / 15)
			rotation = times * 15
		return rotation
