{Line, Point} = require "./../../snapping/Line.coffee"

class exports.BorderRadiusTool

	start: (editor) =>
		@mouseStart = editor.mouse
		@update(null, editor)
		editor.viewController.render()
		borderRadiusHandle = editor.viewController.borderRadiusHandle
		cornerPoint = borderRadiusHandle.cornerPoint
		centerPoint = borderRadiusHandle.centerPoint
		@line = new Line(new Point(cornerPoint.x, cornerPoint.y), new Point(centerPoint.x, centerPoint.y))
		@cornerToCenterDistance = Utils.pointDistance(cornerPoint, centerPoint)

	end: (editor) =>
		@mouseStart = @line = null

	handleMouseMove: (event, editor) => @update(arguments...)

	update: (event, editor) =>
		return unless @line?

		borderRadiusHandle = editor.viewController.borderRadiusHandle
		layer = editor.layer

		mouse = editor.mouse
		cornerPoint = borderRadiusHandle.cornerPoint
		centerPoint = borderRadiusHandle.centerPoint

		intersection = @line.intersection(mouse)
		return unless intersection?

		cornerDistance = Utils.pointDistance(intersection, cornerPoint)
		centerDistance = Utils.pointDistance(intersection, centerPoint)
		cornerToCenter = Utils.pointDistance(cornerPoint, centerPoint)

		if cornerDistance > cornerToCenter and cornerDistance > centerDistance
			ratio = 1
		else if centerDistance > cornerToCenter
			ratio = 0
		else
			ratio = cornerDistance / (cornerDistance + centerDistance)

		intersection = borderRadiusHandle.pointOnLine(cornerPoint, centerPoint, ratio)
		borderRadiusHandle.midX = intersection.x
		borderRadiusHandle.midY = intersection.y

		maxBorderRadius = Math.min(layer.width, layer.height) / 2
		layer.borderRadius = Math.round(maxBorderRadius * ratio)
