{bridge} = require "./Bridge"

traverseUp = (layer) ->
	layers = [layer]
	while layer.superLayer
		layers.push(layer.superLayer)
		layer = layer.superLayer
	return layers

getLayerProperties = (layer) ->
	properties =
		id: layer.id
		name: layer.name or layer.__framerInstanceInfo?.name or "#{layer.constructor.name} #{layer.id}"
		superLayer: null
		__framerInstanceInfo: layer.__framerInstanceInfo

	if not properties.__framerInstanceInfo?
		properties.__framerInstanceInfo = hash: "#il|#{layer.__framerImportedFromPath}|#{properties.name}"

	_.extend(properties, _.pick(layer, [
		"x", "y", "z",
		"index", "width", "height",
		"scale", "opacity",
		"rotationX", "rotationY", "rotationZ",
		"blur"
	]))

	if properties.visible is false
		properties.visibleResult = false
	else
		properties.visibleResult = false not in _.pluck(traverseUp(layer), "visible")

	properties.superLayer = layer.superLayer.id if layer.superLayer?

	return properties

ContextListenerPropertyUpdateKeys = ["name", "superLayer", "index", "visible"]


class ContextListener

	constructor: (context) ->
		@_context = context

		@update = _.debounce(@_update, 10)

		@_context.on("reset", @onContextReset)
		@_context.on("layer:create", @onLayerCreate)
		@_context.on("layer:destroy", @onLayerDestroy)

	_update: =>
		# We need this for backwards compatibility
		layers = @_context._layers or @_context._layerList
		bridge.send("framerView:layers", _.map(@_context._layers, getLayerProperties))

	send: (eventName, info) ->
		window._bridge("ui:#{eventName}", info)

	onContextReset: =>
		@update()

	onLayerCreate: (layer) =>
		@update()
		for key in ContextListenerPropertyUpdateKeys
			layer.on("change:#{key}", @update)

	onLayerDestroy: (layer) =>
		@update()
		for key in ContextListenerPropertyUpdateKeys
			layer.off("change:#{key}", @update)

exports.ContextListener = ContextListener
