EventEmitter = require "eventemitter3"

class Bridge extends EventEmitter

	constructor: ->
		window?._receive = @receive
		window?._respond = @respond
		@count = 0
		@responders = {}

	receive: (command, info) =>
		console.log "#{@count++} bridge.receive", command, info if @debug
		@emit(command, info)

	respond: (request, info) =>
		responder = @responders[request]
		if responder?
			return responder(info)
		else
			return

	send: (command, info) ->
		console.log "#{@count++} bridge.send", command, info if @debug
		window?._bridge?(command, info)

exports.bridge = new Bridge()
