path = require("path")
gulp = require("gulp")

rename = require("gulp-rename")
browserify = require("gulp-browserify")
mocha = require("gulp-mocha")

gulp.task "coffee", ->
	gulp.src("src/index.coffee", read:false)
		.pipe(browserify(
			transform: ["coffeeify"]
			extensions: [".coffee"]))
		.pipe(rename("#{path.basename(__dirname)}.js"))
		.pipe(gulp.dest("./build/"))

gulp.task "watch", ->
	gulp.watch(["src/**/*.coffee", "test/*.coffee", "test/data/*"], ["test"])

gulp.task "test", ->
	gulp.src("test/*.coffee", {read: false})
    	.pipe(mocha({reporter: "spec"}))

gulp.task("default", ["coffee"])