# Framer Studio Viewer

### What is this?

The viewer is responsible for showing layer highlights when hovering layers in the layer panel and the direct manipulation controls in edit mode.

### Workflow

The viewer is automatically build when Framer is compiled. It is not possible to develop the viewer as a standalone watch project.

### Structure

- **StateController** - bridge with native
	- **HighlightComponent** - shows layer highlights
	- **EditStateController** - controls state while in edit mode, passes all interaction to the active tool
		- **BorderRadiusTool**
		- **ResizingTool**
		- **RotationTool**
		- **TranslationTool**
		- **TransformStateController** - controls transform state (cmd key)
			- **OriginTool**
			- **ScaleTool**
	- **PropertyLockController** - decides whether properties are currently locked based on its dependencies
	- **ViewController** - renders all drag-handles and scale ring based on the current state
	- **CursorController** - displays the cursor based on the current state
	- **TooltipManager** - shows the tooltip based on the current state
	- **SnappingModel** - calculates all snapping points and lines
	- **SnappingVisualizer** - renders all snap-lines and the clipped layer shape
		- **Shapes** - does boolean operations on shapes using the Clipper library
		- **SVGLayer** - polyline data to SVG logic

### Drag handles

In edit mode a layer has nine draghandles, the center handle is mostly hidden and used as one of the origin snap points for the origin. The handles each have references to eachother and can be recognized by its `fx` and `fy` values. These values can be 0, 0.5, or 1 depending on their position on the axis. The handles are repositioned each time a layer its transform is changed.

### Snapping

The Snapping Model calculates possible snapping points using all other layer coordinates and the screen. It does this for both the resizing tool and the translation tool. Possible snaps are put inside a snap picker object which returns the best snap. The best snapping option is used to for positioning and eventually used by the snapping visualizer to show the snap lines on the screen.
Resizing is constrained on a line when you use one of the mid handles or hold shift key to lock the layer size ratio. When resizing is constrained on a line, possible snap values are based on the intersections of this line with other layers.

### Things te keep in mind

- All edit interaction listeners are put on the EditStateController which passes events along to the active tool
- The tooltip should only be visible when a tool is active
- Make the tooltip immediately visible on mouse down so the user can see the current value without changing that value

