utils = {}

utils.subLayers = (superLayerId, layers) ->
    _.filter layers, (item) -> item.superLayer == superLayerId

utils.sortLayersByIndex = (layers) ->
    layers.sort (b, a) -> a.index - b.index

utils.sortLayersByHierarchy = (layers) ->

    result = []

    traverse = (layer, level=0) ->
        layer.level = level
        # skip layer if name starts with a dot
        return if layer.name.length > 0 and layer.name.split("")[0] is "."
        result.push(layer)
        subLayers = utils.subLayers(layer.id, layers)
        subLayers = utils.sortLayersByIndex(subLayers)
        subLayers.map (subLayer) -> traverse(subLayer, level+1)

    for layer in utils.sortLayersByIndex(utils.subLayers(null, layers))
        traverse(layer)

    return result

_.extend(exports, utils)