{Panel,PanelRow} = FramerComponents

class Tabs extends PanelRow
		constructor: (options = {}) ->
			super _.defaults options,
				hasLabel: false
				caption: ""
				height: 40
			@left = new Layer
				parent: @
				backgroundColor: null
				name: "properties"
			@propertiesIcon = new Layer
				parent: @left
				width: 11
				height: 11
				backgroundColor: null
				html: '<svg><defs><path d="M6.08474107,7 L2,7 L2,8 L6.08455121,8 C6.289826,8.58510886 6.84604119,9 7.5,9 C8.33420277,9 9,8.32842712 9,7.5 C9,6.66579723 8.32842712,6 7.5,6 C6.84233723,6 6.28934383,6.41740381 6.08474107,7 Z M4.91544879,3 L9,3 L9,4 L4.91525893,4 C4.71065617,4.58259619 4.15766277,5 3.5,5 C2.67157288,5 2,4.33420277 2,3.5 C2,2.67157288 2.66579723,2 3.5,2 C4.15395881,2 4.710174,2.41489114 4.91544879,3 Z M0,1.50643854 C0,0.674455507 0.671540633,0 1.50643854,0 L9.49356146,0 C10.3255445,0 11,0.671540633 11,1.50643854 L11,9.49356146 C11,10.3255445 10.3284594,11 9.49356146,11 L1.50643854,11 C0.674455507,11 0,10.3284594 0,9.49356146 L0,1.50643854 Z M3,3 L4,3 L4,4 L3,4 L3,3 Z M7,7 L8,7 L8,8 L7,8 L7,7 Z" id="propertiespath-1"></path><mask id="propertiesmask-2" maskContentUnits="userSpaceOnUse" maskUnits="objectBoundingBox" x="-1" y="-1" width="13" height="13"><rect x="-1" y="-1" width="13" height="13" fill="white"></rect><use xlink:href="#propertiespath-1" fill="black"></use></mask> </defs><g id="properties" stroke="none" fill="none"><use fill="#FFFFFF" fill-rule="evenodd" xlink:href="#propertiespath-1"></use></g></svg>'

			@right = new Layer
				parent: @
				backgroundColor: null
				name: "options"
			@optionsIcon = new Layer
				parent: @right
				width: 11
				height: 11
				backgroundColor: null
				html: '<svg><defs><rect id="optionspath-2" x="0" y="0" width="11" height="11" rx="1.5"></rect><mask id="optionsmask-2" maskContentUnits="userSpaceOnUse" maskUnits="objectBoundingBox" x="-1" y="-1" width="13" height="13"><rect x="-1" y="-1" width="13" height="13" fill="white"></rect><use xlink:href="#optionspath-1" fill="black"></use></mask></defs><g id="icon-curve-edit" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g id="Rectangle-272"><use fill="#FFF" fill-rule="evenodd" xlink:href="#optionspath-2"></use><use stroke="#141414" mask="url(#optionsmask-2)" stroke-width="2" xlink:href="#optionspath-1"></use></g><path d="M2,8.5 C2,8.5 8.5,8.5 8.5,2" id="Path-64" stroke="#141414"></path></g></svg>'

			for layer in [@left, @right]

				if layer.name != options.currentTabName
					layer.opacity = 0.4

			@layout()
			@left.onClick =>
				@emit "change:value", @left.name
			@right.onClick =>
				@emit "change:value", @right.name
		layout: ->
			width = @width / 2
			@left.width = @right.width = width
			@right.x = width
			@left.height = @right.height = @height
			offset = 17
			@propertiesIcon.centerX(offset-1)
			@optionsIcon.centerX(-offset)
			@propertiesIcon.centerY()
			@optionsIcon.centerY()
			@propertiesIcon.pixelAlign()
			@optionsIcon.pixelAlign()


class exports.SwitchPanel extends Panel
		constructor: (options = {}) ->
			@tabs = new Tabs
				currentTabName: options.currentTabName
			super options
			@add @tabs

		render: =>
			offsetY = 0
			for row in @rows
				continue if not row.visible
				row.width = @width
				row.y = offsetY
				row.layout?()
				offsetY += row.calculatedHeight
			@calculatedHeight = offsetY
			@height = @calculatedHeight
