{bridge}		= require "./Bridge"
{Constants} = require "./Constants"
{SwitchPanel} = require '../shared/SwitchPanel'

class exports.AutoCodePanelStack extends window.FramerComponents.PanelStack

		constructor: (options = {}) ->
				super _.defaults options, {}

				bridge.on "show", => @visible = true
				bridge.on "hide", => @visible = false
				bridge.on Constants.messages.framerview.layerEdited, @handleLayerEdited
				bridge.on "externalValueUpdate", @handleExternalValueUpdate
				bridge.on "undoValue", @handleUndoValue
				bridge.on "framerView:lockProperties", @handleLockProperties

				@directManipulationProperties = {}

				@omitDefaults = true
				@visible = false

				@switchPanel = new SwitchPanel
					currentTabName: @currentTabName
				@switchPanel.tabs.on "change:value", @handleTabChange
				@add @switchPanel

		destroy: ->
				@reset()

		configure: (data) ->

		setData: (data) =>
				@visible = true
				@reset()
				@configure(data)
				@pathPrefix = data.pathPrefix

				@switchPanel.visible = data.switchAvailable ? false

				@initialValues = data?.layerProperties
				@initialValues = {} unless @initialValues?

				for key, value of @directManipulationProperties
						@initialValues[key] = value.default unless @initialValues[key]?

						value.initial = @initialValues[key]
						value.changed = false

				settings = {}
				for member in data.frozenMembers
					Utils.setValueForKeyPath settings, member, disabled: true

				@setMembers = data.setMembers
				if @pathPrefix? and @pathPrefix.length > 0
					@setMembers = @setMembers[@pathPrefix]
					settings = settings[@pathPrefix]
				@read(@setMembers, @initialValues, settings)

				@addPropertyListeners()

				window.scrollTo(0, 0);

		getData: () ->
				return @write()

		addPropertyListeners: ->
				for property in @properties
						property.on "change:value", @handlePropertyValueChange

		removePropertyListeners: ->
				for property in @properties
						property.off "change:value", @handlePropertyValueChange
						property.reset()

		reset: ->
				@removePropertyListeners()

		propertyByDataPath: (dataPath) ->
				for property in @properties
						if @prefixDataPath(property.dataPath) is dataPath
								return property

				return null

		handleTabChange: (value) =>
			if value is @currentTabName
				return
			bridge.send Constants.messages.propertiespanel.activatePanel,
				name: value

		handleLayerEdited: (data) =>

				@inBatchMode = true

				changedProperties = []
				for dataPath, settings of @directManipulationProperties

						newValue = data.properties[dataPath]
						property = @propertyByDataPath(dataPath)

						continue if not newValue?
						continue if (settings.initial + "") is (newValue + "") unless property?.changed or @setMembers[dataPath]?

						if settings.round
								value = Math.round(newValue)
						else
								value = newValue

						value = value + "" if value?

						if @omitDefaults
								value = null if value is settings.default + ""

						if value isnt undefined and property?
								if not @omitDefaults and not property.changed and value is property.default + ""
										value = null

								currentValue = property.getData()
								if ((value is null and currentValue isnt null) or
										(value isnt null and value.toString() isnt currentValue)
								)
										property.setValueWithData(value)
										property.changed = true
										changedProperties.push
												name: @prefixDataPath(dataPath)
												value: value
												type: property.type

				if changedProperties.length > 0
						bridge.send(
								Constants.messages.propertiespanel.propertiesChanged,
								properties: changedProperties
						)

				@inBatchMode = false

		prefixDataPath: (dataPath) ->
			if @pathPrefix? and @pathPrefix.length > 0
				return "#{@pathPrefix}.#{dataPath}"
			else
				return dataPath

		handlePropertyValueChange: (newValue, oldValue, prop) =>

				return if @inBatchMode

				value = prop.getData()
				initialValue = prop.valueToData(@initialValues[prop.dataPath])
				defaultValue = @directManipulationProperties[prop.dataPath]?.default
				#Only send the initialValue value if it isn't also the defaultValue
				if not value? and initialValue != defaultValue
					value = initialValue
				update =
						name: @prefixDataPath(prop.dataPath)
						value: value
						type: prop.type

				bridge.send(
						Constants.messages.propertiespanel.propertyChanged
						update
				)

		# override
		handlePropertyRequest: (request) =>
				switch request?.type
						when "color" then bridge.send "colorPickerRequested", request
						when "image" then bridge.send "imagePickerRequested", request
						when "drag:start"
								document.body.classList.add "dragging"
								bridge.send "drag:start", {}
						when "drag:end"
								document.body.classList.remove "dragging"
								bridge.send "drag:end", {}
						when "click:lock"
							request.name = @prefixDataPath(request.name)
							bridge.send Constants.messages.propertiespanel.propertyLockClicked, request

		handleExternalValueUpdate: (update) =>
			property = @propertyByDataPath(update?.name)
			if property?
				property.setValueWithData(update.value)

		handleLockProperties: (data) =>
			properties = data.properties
			for p in properties
				property = @propertyByDataPath(p)
				property.enable(false)

		handleUndoValue: (update) =>

				inBatchMode = @inBatchMode
				@inBatchMode = true

				@handleExternalValueUpdate(update)

				@inBatchMode = inBatchMode
