{AutoCodePanelStack} = require '../shared/AutoCodePanelStack'
{MainPanel} = require './MainPanel'
{BorderPanel} = require './BorderPanel'
{TransformPanel} = require './TransformPanel'
{FiltersPanel} = require './FiltersPanel'

class exports.PropertiesPanelStack extends AutoCodePanelStack

	constructor: (options = {}) ->
		@currentTabName = 'properties'
		super options

		@directManipulationProperties =
			x:            round: true, default: 0
			y:            round: true, default: 0
			width:        round: true, default: Framer.Defaults.Layer.width
			height:       round: true, default: Framer.Defaults.Layer.height
			rotation:     round: true, default: 0
			rotationX:    round: true, default: 0
			rotationY:    round: true, default: 0
			rotationZ:    round: true, default: 0
			scale:        round: false, default: 1
			scaleX:       round: false, default: 1
			scaleY:       round: false, default: 1
			originX:      round: false, default: 0.5
			originY:      round: false, default: 0.5
			originZ:      round: false, default: 0
			borderRadius: round: true, default: 0

		@mainPanel = new MainPanel
		@add @mainPanel

		@borderPanel = new BorderPanel
		@add @borderPanel

		@transformPanel = new TransformPanel
		@add @transformPanel

		@filtersPanel = new FiltersPanel
		@filtersPanelToggle = @addWithToggle @filtersPanel

	configure: (data) ->
		super data

		targetType = data.objectType
		panelType = data.panelType
		toggleStates = data.toggleStates

		collapsiblePanelToggles = [
			@filtersPanelToggle
		]

		auxiliraryPanels = [
			@borderPanel,
			@transformPanel
		]

		@mainPanel.unhideAllRows()

		for panel in auxiliraryPanels
			panel.hide(false)

		for toggle in collapsiblePanelToggles
			toggle.hide(false)

		if targetType is "@BackgroundLayerOptions"
			for panel in auxiliraryPanels
				panel.hide(true)
			for toggle in collapsiblePanelToggles
				toggle.hide(true)
			for row in @mainPanel.rows
				row.visible = false

			@mainPanel.backgroundRow.visible = true
			@mainPanel.render()

		@omitDefaults = panelType isnt "state"

		for toggle in collapsiblePanelToggles
			toggleOpen = toggleStates?[toggle.target.caption]
			if toggleOpen and toggle.visible
				toggle.open(false)
				toggle.target.unhideAllRows()
			else
				toggle.close(false)

		@render()
