{StringProperty,NumberProperty,ColorProperty}  = FramerComponents
{Panel,PanelRow,MonoInputRow,StereoInputRow,PairedInputRow} = FramerComponents
{TextInput,ImageInput,NumberInput,SliderInput,DialInput} = FramerComponents

class exports.MainPanel extends Panel

    constructor: (options = {}) ->

        @caption = "Main Panel"

        super _.defaults options, {}

        @positionRow = new StereoInputRow
            caption: "Position"
            properties: [
                new NumberProperty
                    dataPath: "x"
                    caption: "X"
                new NumberProperty
                    dataPath: "y"
                    caption: "Y"
            ]

        @sizeRow = new StereoInputRow
            caption: "Size"
            properties: [
                new NumberProperty
                    dataPath: "width"
                    caption: "W"
                    min: 0
                new NumberProperty
                    dataPath: "height"
                    caption: "H"
                    min: 0
            ]

        @opacityRow = new PairedInputRow
            caption: "Opacity"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "opacity"
                min: 0
                max: 1
                decimals: 2
                step: 0.05

        @backgroundRow = new StereoInputRow
            caption: "Background"
            properties: [
                new ColorProperty dataPath: "backgroundColor"
                new StringProperty
                    caption: "Choose"
                    dataPath: "image"
                    editorType: ImageInput
            ]

        @add @positionRow
        @add @sizeRow
        @add @backgroundRow
        @add @opacityRow
