{Property,NumberProperty,ColorProperty}  = FramerComponents
{Panel,PanelRow,MonoInputRow,StereoInputRow,PairedInputRow} = FramerComponents
{TextInput,ComboTextInput,NumberInput,SliderInput,DialInput} = FramerComponents

class exports.FiltersPanel extends Panel

    constructor: (options = {}) ->

        @caption = "Filters"

        super _.defaults options, {}

        blurRow = new PairedInputRow
            caption: "Blur"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "blur"
                min: 0
                sliderMax: 50
                step: 1
                decimals: 0

        brightnessRow = new PairedInputRow
            caption: "Brightness"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "brightness"
                min: 0
                sliderMin: 0
                sliderMax: 300
                step: 1
                decimals: 0

        contrastRow = new PairedInputRow
            caption: "Contrast"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "contrast"
                min: 0
                max: 100
                step: 1
                decimals: 0

        grayscaleRow = new PairedInputRow
            caption: "Grayscale"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "grayscale"
                min: 0
                max: 100
                step: 1
                decimals: 0

        huerotateRow = new PairedInputRow
            caption: "hueRotate"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "hueRotate"
                min: 0
                max: 360
                step: 1
                decimals: 0

        invertRow = new PairedInputRow
            caption: "Invert"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "invert"
                min: 0
                max: 100
                step: 1
                decimals: 0

        saturateRow = new PairedInputRow
            caption: "Saturate"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "saturate"
                min: 0
                max: 100
                step: 1
                decimals: 0

        sepiaRow = new PairedInputRow
            caption: "Sepia"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "sepia"
                min: 0
                max: 100
                step: 1
                decimals: 0

        @add blurRow
        @add brightnessRow
        @add contrastRow
        @add grayscaleRow
        @add huerotateRow
        @add invertRow
        @add saturateRow
        @add sepiaRow
