{StringProperty,NumberProperty,ColorProperty}  = FramerComponents
{Panel,PanelRow,StereoInputRow,PairedInputRow} = FramerComponents
{TextInput,ImageInput,NumberInput,SliderInput,DialInput} = FramerComponents

class exports.BorderPanel extends Panel

    constructor: (options = {}) ->

        @caption = "Border Panel"

        super _.defaults options, {}

        borderColorProperty = new ColorProperty
            dataPath: "borderColor"

        borderWidthProperty = new NumberProperty
            min: 0
            dataPath: "borderWidth"
            caption: "Width"
            abbreviatedCaption: "W"

        borderColorProperty.on "change:value", (newValue) =>
            return unless newValue?
            if (borderWidthProperty.value is null or borderWidthProperty.value is 0)
                borderWidthProperty.value = 1

        @borderRow = new StereoInputRow
            caption: "Border"
            properties: [
                borderColorProperty,
                borderWidthProperty
            ]

        @radiusRow = new PairedInputRow
            caption: "Radius"
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "borderRadius"
                min: 0
                sliderMin: 0
                sliderMax: 100
                step: 1
                decimals: 0

        shadowColorProperty = new ColorProperty
            dataPath: "shadowColor"

        shadowSpreadProperty = new NumberProperty
            dataPath: "shadowSpread"
            caption: "Spread"
            abbreviatedCaption: "S"

        shadowColorProperty.on "change:value", (newValue) =>
            return unless newValue?
            if (shadowSpreadProperty.value is null or shadowSpreadProperty.value is 0)
                shadowSpreadProperty.value = 1

        @shadowColorRow = new StereoInputRow
            caption: "Shadow"
            properties: [
                shadowColorProperty,
                shadowSpreadProperty
            ]

        @shadowPositionRow = new StereoInputRow
            caption: " "
            properties: [
                new NumberProperty dataPath: "shadowX", caption: "X"
                new NumberProperty dataPath: "shadowY", caption: "Y"
            ]

        @shadowBlurRow = new PairedInputRow
            caption: " "
            editorTypes: [NumberInput, SliderInput]
            property: new NumberProperty
                dataPath: "shadowBlur"
                min: 0
                sliderMax: 100
                step: 1
                decimals: 0
                caption: "Blur"
                abbreviatedCaption: "B"

        @add @borderRow
        @add @radiusRow
        @add @shadowColorRow
        @add @shadowPositionRow
        @add @shadowBlurRow
