class exports.TableComponent extends Framer.Layer

    constructor: (options = {}) ->
        options.name ?= "TableComponent"
        super options
        @_rowLayers = []
        @_selectedRows = {}
        @bumper = new Layer backgroundColor: null

    render: =>

        y = 0

        if @totalRows() > 0
            for index in [0..@totalRows()-1]

                # Try to get an existing row layer
                rowLayer = @_rowLayers[index]

                if not rowLayer
                    rowLayer = @_rowLayers[index] = @createRow()

                rowLayer.superLayer = @

                _.extend rowLayer,
                    y: y
                    width: @width
                    height: @heightForRow(index)
                    visible: true

                @updateRow(index, rowLayer)

                y += rowLayer.height + @marginForRow(index)

        # We just set the rows to invisible so we can use them later
        for removalIndex in [@totalRows()..@_rowLayers.length+1]
            @_rowLayers[removalIndex]?.visible = false
            @_rowLayers[removalIndex]?.data = null

        @bumper.y = y
        @bumper.height = 400
        @bumper.width = @width

        @height = y

    # Row data and rendering
    totalRows: -> 20
    createRow: -> new Layer
    heightForRow: (index) -> 80
    marginForRow: (index) -> 10
    updateRow: (index, row) -> Utils.labelLayer(row, "index: #{index}")
    renderRow: (row) => @updateRow(@indexForRow(row), row)
    indexForRow: (row) -> @_rowLayers.indexOf(row)
    rowForIndex: (index) -> @_rowLayers?[index] or null

    # Selection
    setSelectedRows: (type, rows) ->
        return if _.isEqual(rows, @_selectedRows[type])
        previousSelectedRows = @_selectedRows[type]
        @_selectedRows[type] = rows
        _.map(previousSelectedRows, @renderRow)
        _.map(@_selectedRows[type], @renderRow)
        @emit("change:selection:#{type}", {old:previousSelectedRows, new:@_selectedRows[type]})
    setSelectedRowIndexes: (type, rowIndexes) ->
        @setSelectedRows(_.map(rowIndexes, @rowForIndex))
    getSelectedRows: (type) -> _.clone(@_selectedRows[type]) or []
    isRowSelected: (type, row) -> row in @_selectedRows[type] if @_selectedRows[type]
    unselectRows: (type) -> @setSelectedRows(type, [])

