{OptionListProperty,StringProperty,FunctionProperty,NumberProperty}  = FramerComponents
{Panel,MonoInputRow,WidgetRow,PairedInputRow} = FramerComponents
{NumberInput,SliderInput,RadioSelectInput} = FramerComponents
{Curve} = FramerComponents
{LinearAnimator,BezierCurveAnimator,SpringRK4Animator} = Framer

class exports.CurvePanel extends Panel
	constructor: (options = {}) ->
		super options

		@caption = "Curve"

		@curveProperty = new StringProperty
			dataPath: "curve"

		@curveSelectionProperty = new OptionListProperty
			editorType: RadioSelectInput
			availableOptions:
				"linear": "Linear"
				"ease": "Ease"
				"ease-in": "Ease In"
				"ease-out": "Ease Out"
				"ease-in-out": "Ease In Out"
				"spring": "Spring"

		@curveRow = new MonoInputRow
			caption: "Curve"
			editorType: RadioSelectInput
			properties: @curveSelectionProperty

		@widgetRow = new WidgetRow
			widgetType: Curve
			caption: " "

		@add @curveRow
		@add @widgetRow

		@timeProperty = new NumberProperty
			dataPath: "time"
			caption: "S"
			min: 0
			sliderMax: 5
			decimals: 2
			step: 0.25

		@springProperty = new FunctionProperty
			name: "spring"

		@tensionProperty = new NumberProperty
			min: 0
			max: 1000
			sliderMin: 100
			sliderTransform: (x) -> Math.pow(10,x)
			sliderInverseTransform: (x) -> Math.log10(x)
			decimals: 0
			caption: " "

		@frictionProperty = new NumberProperty
			min: 0
			max: 100
			sliderMin: 10
			sliderTransform: (x) -> Math.pow(10,x)
			sliderInverseTransform: (x) -> Math.log10(x)
			decimals: 0
			caption: " "

		@velocityProperty = new NumberProperty
			min: 0
			max: 25
			step: 1
			decimals: 0
			caption: " "

		toleranceProperty = new NumberProperty
		defaultAnimator = new SpringRK4Animator
		@tensionProperty.default = defaultAnimator.options.tension
		@frictionProperty.default = defaultAnimator.options.friction
		@velocityProperty.default = defaultAnimator.options.velocity
		@springProperty.addArgument(@tensionProperty)
		@springProperty.addArgument(@frictionProperty)
		@springProperty.addArgument(@velocityProperty)
		@springProperty.addArgument(toleranceProperty)

		@timeRow = new PairedInputRow
			caption: "Time"
			editorTypes: [NumberInput, SliderInput]
			property: @timeProperty

		@tension = new PairedInputRow
			caption: "Tension"
			editorTypes: [NumberInput, SliderInput]
			rightEditorInsetY: 2
			property: @tensionProperty

		@friction = new PairedInputRow
			caption: "Friction"
			editorTypes: [NumberInput, SliderInput]
			rightEditorInsetY: 2
			property: @frictionProperty

		@velocity = new PairedInputRow
			caption: "Velocity"
			editorTypes: [NumberInput, SliderInput]
			rightEditorInsetY: 2
			property: @velocityProperty

		# @timeRow.on "click:disabledLayer", @highlightEaseOption
		# @tension.on "click:disabledLayer", @highlightSpringOption
		# @friction.on "click:disabledLayer", @highlightSpringOption
		# @velocity.on "click:disabledLayer", @highlightSpringOption

		@add @timeRow
		@add @tension
		@add @friction
		@add @velocity

		@properties = [@curveProperty,@timeProperty]

		@curveChangesEnabled = true
		@curveSelectionProperty.on "change:value", @curveSelectionChanged

		@curveSelectionProperty.on "request", (request) =>
			request.name = @curveProperty.dataPath
			@curveProperty.emit "request", request

		@springProperty.on "request", (request) =>
			request.name = @curveProperty.dataPath
			@curveProperty.emit "request", request


		@tensionProperty.on "change:value", @springChanged
		@frictionProperty.on "change:value", @springChanged
		@velocityProperty.on "change:value", @springChanged

		@curveProperty.on "change:value", (value) =>
			@curveChangesEnabled = false
			@curveSelectionProperty.settings = @curveProperty.settings
			@springProperty.settings = @curveProperty.settings
			if _.startsWith value, "spring"
				@curveSelectionProperty.value = "spring"
				@springProperty.setValueWithData(value)
			else
				if not @curveSelectionProperty.validateOption(value)
					@curveSelectionProperty.default = ""
					value = ""
				@curveSelectionProperty.value = value
			@curveChangesEnabled = true

		@curveProperty.on "reset", =>
			@curveSelectionProperty.reset()
			@springProperty.reset()

		@curveProperty.on "change:default", (defaultValue) =>
			@curveChangesEnabled = false
			@curveSelectionProperty.default = defaultValue
			@curveChangesEnabled = true
			if defaultValue?
				@updateWidget()

	highlightSpringOption: =>
		@curveRow.editor.highlight("spring")

	highlightEaseOption: =>
		@curveRow.editor.highlight("ease")

	springChanged: =>
		@updateCurveProperty(@springProperty.valueAsString())
		@updateWidget()

	updateCurveProperty: (value) ->
		return if not @curveChangesEnabled
		@curveProperty.value = value

	curveSelectionChanged: (value) =>
		if value == "spring"
			@widgetRow.widget.factor = 0.5
			@timeRow.disable()
			@tension.enable()
			@friction.enable()
			@velocity.enable()
			@springChanged()
		else
			@widgetRow.widget.factor = 1
			@timeRow.enable()
			@tension.disable()
			@friction.disable()
			@velocity.disable()
			@updateCurveProperty(value)
			@updateWidget()

	updateWidget: ->
		options = {}
		time = @timeProperty.value ? @timeProperty.default
		curve = @curveProperty.value ? @curveProperty.default
		if time?
			options.time = time
		if curve?
			options.curve = curve
		animator = Animation._createAnimator options
		if @curveProperty.settings.disabled
			animator = null
		animator?.options.tolerance = 1/10000
		@widgetRow.widget.render(animator)
