{NumberProperty,FunctionProperty,OptionListProperty} = FramerComponents
{Panel,PanelRow,MonoInputRow,StereoInputRow,PairedInputRow} = FramerComponents
{TextInput,ComboTextInput,NumberInput,SliderInput,DialInput,SelectInput,RadioSelectInput} = FramerComponents

class exports.AnimationOptionsPanel extends Panel

	constructor: (options = {}) ->

		@caption = "Animation Options"

		super _.defaults options, {}

		@delayRow = new PairedInputRow
			caption: "Delay"
			editorTypes: [NumberInput, SliderInput]
			property: new NumberProperty
				dataPath: "delay"
				caption: "S"
				min: 0
				sliderMax: 5

		@repeatRow = new PairedInputRow
			caption: "Repeat"
			editorTypes: [NumberInput, SliderInput]
			property: new NumberProperty
				dataPath: "repeat"
				min: 0
				sliderMax: 10

		@colorModel = new MonoInputRow
			caption: "Color"
			rightEditorInsetY: 2
			properties: new OptionListProperty
				editorType: RadioSelectInput
				dataPath: "colorModel"
				availableOptions:
					"rgb": "RGB"
					"hsl": "HSL"
					"husl": "HUSL"

		@add @delayRow
		@add @repeatRow
		@add @colorModel
