path = require("path")
gulp = require("gulp")
reloader = require("macreloader")

rename = require("gulp-rename")
browserify = require("gulp-browserify")

gulp.task "static", ->
	gulp.src(["./static/*", "./static/*/*"])
		.pipe(gulp.dest("./build"))

gulp.task "coffee", ["layers", "properties","animation"]

gulp.task "layers", ->
	gulp.src("src/layers/index.coffee", read:false)
		.pipe(browserify(
			transform: ["coffeeify"]
			extensions: [".coffee"]))
		.pipe(rename("FramerStudioLayerPanel.js"))
		.pipe(gulp.dest("./build/"))

gulp.task "properties", ->
	gulp.src("src/properties/index.coffee", read:false)
		.pipe(browserify(
			transform: ["coffeeify"]
			extensions: [".coffee"]))
		.pipe(rename("FramerStudioPropertiesPanel.js"))
		.pipe(gulp.dest("./build/"))

gulp.task "animation", ->
	gulp.src("src/animation/index.coffee", read:false)
		.pipe(browserify(
			transform: ["coffeeify"]
			extensions: [".coffee"]))
		.pipe(rename("FramerStudioAnimationPanel.js"))
		.pipe(gulp.dest("./build/"))

gulp.task "watch", ["coffee"], ->
	gulp.watch ["src/**/*.coffee"], ->
		gulp.run "coffee", ->
			# console.log "hello"
			reloader.reload("file://#{__dirname}/build/index-properties.html")

gulp.task("default", ["static", "coffee"])
