(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);throw new Error("Cannot find module '"+o+"'")}var f=n[o]={exports:{}};t[o][0].call(f.exports,function(e){var n=t[o][1][e];return s(n?n:e)},f,f.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
'use strict';

/**
 * Representation of a single EventEmitter function.
 *
 * @param {Function} fn Event handler to be called.
 * @param {Mixed} context Context for function execution.
 * @param {Boolean} once Only emit once
 * @api private
 */
function EE(fn, context, once) {
  this.fn = fn;
  this.context = context;
  this.once = once || false;
}

/**
 * Minimal EventEmitter interface that is molded against the Node.js
 * EventEmitter interface.
 *
 * @constructor
 * @api public
 */
function EventEmitter() { /* Nothing to set */ }

/**
 * Holds the assigned EventEmitters by name.
 *
 * @type {Object}
 * @private
 */
EventEmitter.prototype._events = undefined;

/**
 * Return a list of assigned event listeners.
 *
 * @param {String} event The events that should be listed.
 * @returns {Array}
 * @api public
 */
EventEmitter.prototype.listeners = function listeners(event) {
  if (!this._events || !this._events[event]) return [];
  if (this._events[event].fn) return [this._events[event].fn];

  for (var i = 0, l = this._events[event].length, ee = new Array(l); i < l; i++) {
    ee[i] = this._events[event][i].fn;
  }

  return ee;
};

/**
 * Emit an event to all registered event listeners.
 *
 * @param {String} event The name of the event.
 * @returns {Boolean} Indication if we've emitted an event.
 * @api public
 */
EventEmitter.prototype.emit = function emit(event, a1, a2, a3, a4, a5) {
  if (!this._events || !this._events[event]) return false;

  var listeners = this._events[event]
    , len = arguments.length
    , args
    , i;

  if ('function' === typeof listeners.fn) {
    if (listeners.once) this.removeListener(event, listeners.fn, true);

    switch (len) {
      case 1: return listeners.fn.call(listeners.context), true;
      case 2: return listeners.fn.call(listeners.context, a1), true;
      case 3: return listeners.fn.call(listeners.context, a1, a2), true;
      case 4: return listeners.fn.call(listeners.context, a1, a2, a3), true;
      case 5: return listeners.fn.call(listeners.context, a1, a2, a3, a4), true;
      case 6: return listeners.fn.call(listeners.context, a1, a2, a3, a4, a5), true;
    }

    for (i = 1, args = new Array(len -1); i < len; i++) {
      args[i - 1] = arguments[i];
    }

    listeners.fn.apply(listeners.context, args);
  } else {
    var length = listeners.length
      , j;

    for (i = 0; i < length; i++) {
      if (listeners[i].once) this.removeListener(event, listeners[i].fn, true);

      switch (len) {
        case 1: listeners[i].fn.call(listeners[i].context); break;
        case 2: listeners[i].fn.call(listeners[i].context, a1); break;
        case 3: listeners[i].fn.call(listeners[i].context, a1, a2); break;
        default:
          if (!args) for (j = 1, args = new Array(len -1); j < len; j++) {
            args[j - 1] = arguments[j];
          }

          listeners[i].fn.apply(listeners[i].context, args);
      }
    }
  }

  return true;
};

/**
 * Register a new EventListener for the given event.
 *
 * @param {String} event Name of the event.
 * @param {Functon} fn Callback function.
 * @param {Mixed} context The context of the function.
 * @api public
 */
EventEmitter.prototype.on = function on(event, fn, context) {
  var listener = new EE(fn, context || this);

  if (!this._events) this._events = {};
  if (!this._events[event]) this._events[event] = listener;
  else {
    if (!this._events[event].fn) this._events[event].push(listener);
    else this._events[event] = [
      this._events[event], listener
    ];
  }

  return this;
};

/**
 * Add an EventListener that's only called once.
 *
 * @param {String} event Name of the event.
 * @param {Function} fn Callback function.
 * @param {Mixed} context The context of the function.
 * @api public
 */
EventEmitter.prototype.once = function once(event, fn, context) {
  var listener = new EE(fn, context || this, true);

  if (!this._events) this._events = {};
  if (!this._events[event]) this._events[event] = listener;
  else {
    if (!this._events[event].fn) this._events[event].push(listener);
    else this._events[event] = [
      this._events[event], listener
    ];
  }

  return this;
};

/**
 * Remove event listeners.
 *
 * @param {String} event The event we want to remove.
 * @param {Function} fn The listener that we need to find.
 * @param {Boolean} once Only remove once listeners.
 * @api public
 */
EventEmitter.prototype.removeListener = function removeListener(event, fn, once) {
  if (!this._events || !this._events[event]) return this;

  var listeners = this._events[event]
    , events = [];

  if (fn) {
    if (listeners.fn && (listeners.fn !== fn || (once && !listeners.once))) {
      events.push(listeners);
    }
    if (!listeners.fn) for (var i = 0, length = listeners.length; i < length; i++) {
      if (listeners[i].fn !== fn || (once && !listeners[i].once)) {
        events.push(listeners[i]);
      }
    }
  }

  //
  // Reset the array, or remove it completely if we have no more listeners.
  //
  if (events.length) {
    this._events[event] = events.length === 1 ? events[0] : events;
  } else {
    delete this._events[event];
  }

  return this;
};

/**
 * Remove all listeners or only the listeners for the specified event.
 *
 * @param {String} event The event want to remove all listeners for.
 * @api public
 */
EventEmitter.prototype.removeAllListeners = function removeAllListeners(event) {
  if (!this._events) return this;

  if (event) delete this._events[event];
  else this._events = {};

  return this;
};

//
// Alias methods names because people roll like that.
//
EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
EventEmitter.prototype.addListener = EventEmitter.prototype.on;

//
// This function doesn't apply anymore.
//
EventEmitter.prototype.setMaxListeners = function setMaxListeners() {
  return this;
};

//
// Expose the module.
//
EventEmitter.EventEmitter = EventEmitter;
EventEmitter.EventEmitter2 = EventEmitter;
EventEmitter.EventEmitter3 = EventEmitter;

//
// Expose the module.
//
module.exports = EventEmitter;

},{}],2:[function(require,module,exports){
var Constants, TableComponent, bridge, utils,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

bridge = (require("./../shared/Bridge")).bridge;

utils = require("./../shared/Utils");

Constants = require("./../shared/Constants").Constants;

TableComponent = require("./TableComponent").TableComponent;

exports.LayerPanel = (function(superClass) {
  extend(LayerPanel, superClass);

  function LayerPanel(options) {
    var framerStudioMessages, framerViewMessages;
    if (options == null) {
      options = {};
    }
    this.sendItemRollOver = bind(this.sendItemRollOver, this);
    this.handleStudioLayerPanelLeave = bind(this.handleStudioLayerPanelLeave, this);
    this.handleStudioLayerPanelEnter = bind(this.handleStudioLayerPanelEnter, this);
    this.handleScrollerResize = bind(this.handleScrollerResize, this);
    this.handleStudioState = bind(this.handleStudioState, this);
    this.handleClick = bind(this.handleClick, this);
    this.handleMouseOver = bind(this.handleMouseOver, this);
    this.setData = bind(this.setData, this);
    if (options.name == null) {
      options.name = "LayerPanel";
    }
    this.messages = Constants.messages.layerpanel;
    this.data = [];
    LayerPanel.__super__.constructor.call(this, options);
    this.render();
    framerViewMessages = Constants.messages.framerview;
    framerStudioMessages = Constants.messages.studio;
    bridge.on(framerViewMessages.layers, this.setData);
    bridge.on(framerStudioMessages.state, this.handleStudioState);
    bridge.on(framerStudioMessages.layerPanelEnter, this.handleStudioLayerPanelEnter);
    bridge.on(framerStudioMessages.layerPanelLeave, this.handleStudioLayerPanelLeave);
    this.bumper.on(Events.MouseOver, (function(_this) {
      return function() {
        if (_this._highlightedLayerId != null) {
          _this.unhighlightRow();
          return bridge.send(_this.messages.itemRollOut, {});
        }
      };
    })(this));
  }

  LayerPanel.prototype.setData = function(data) {
    var ref;
    console.log("layerPanel:setData");
    if (this._highlightedLayerId && (ref = this._highlightedLayerId, indexOf.call(_.pluck(data, "id"), ref) < 0)) {
      bridge.send(this.messages.reset, {});
    }
    this.data = utils.sortLayersByHierarchy(data);
    return this.render();
  };

  LayerPanel.prototype.totalRows = function() {
    return this.data.length;
  };

  LayerPanel.prototype.heightForRow = function() {
    return Constants.sizes.rowHeight;
  };

  LayerPanel.prototype.marginForRow = function() {
    return 0;
  };

  LayerPanel.prototype.createRow = function() {
    var row;
    row = new Layer({
      height: this.heightForRow()
    });
    row.style = {
      borderBottom: "1px solid " + Constants.colors.border
    };
    row.indentLayer = new Layer({
      x: Constants.sizes.indent,
      width: row.width - Constants.sizes.indent,
      height: Constants.sizes.indentHeight,
      parent: row
    });
    row.indentLayer.style = {
      background: "repeating-linear-gradient(to right, " + Constants.colors.indent + ", " + Constants.colors.indent + " " + Constants.sizes.indentWidth + "px, " + Constants.colors.background + " " + Constants.sizes.indentWidth + "px, " + Constants.colors.background + " " + Constants.sizes.indent + "px )"
    };
    row.indentLayer.centerY();
    row.textLayer = new Layer({
      width: row.width,
      height: this.heightForRow(),
      parent: row,
      backgroundColor: Constants.colors.background
    });
    row.textLayer.style = {
      font: "11px -apple-system, Helvetica Neue, Helvetica",
      color: Constants.colors.text,
      lineHeight: (this.heightForRow()) + "px",
      "-webkit-user-select": "none",
      "-webkit-font-smoothing": "subpixel-antialiased"
    };
    row.onMouseOver(this.handleMouseOver);
    row.onMouseDown(this.handleClick);
    return row;
  };

  LayerPanel.prototype.updateRow = function(index, row) {
    var color, indent;
    row.data = this.data[index];
    row.textLayer.html = "" + row.data.name;
    indent = (row.data.level + 1) * Constants.sizes.indent;
    row.textLayer.x = indent;
    row.textLayer.width = row.width - indent;
    if (this.isRowSelected("hover", row)) {
      row.textLayer.style.color = Constants.colors.textHighlight;
    } else {
      row.textLayer.style.color = this._textColor(row.data);
    }
    color = this.isRowSelected("selection", row) ? Constants.colors.tableSelectionBackground : Constants.colors.background;
    row.textLayer.backgroundColor = color;
    return row.backgroundColor = color;
  };

  LayerPanel.prototype.handleMouseOver = function(event, row) {
    var ref;
    this._highlightedLayerId = row != null ? (ref = row.data) != null ? ref.id : void 0 : void 0;
    return this.sendItemRollOver(row);
  };

  LayerPanel.prototype.handleClick = function(event, row) {
    return bridge.send(this.messages.itemClick, {
      id: row.data.id,
      data: row.data.__framerInstanceInfo,
      state: row.states.current.name
    });
  };

  LayerPanel.prototype.handleStudioState = function(state) {
    var i, id, len, ref, ref1, ref2, row;
    console.log("layerPanel:handleStudioState", state);
    if (this._highlightedLayerId === ((ref = state.highlightingTarget) != null ? ref.runtimeId : void 0)) {
      return;
    }
    id = (ref1 = state.highlightingTarget) != null ? ref1.runtimeId : void 0;
    if (id != null) {
      ref2 = this._rowLayers;
      for (i = 0, len = ref2.length; i < len; i++) {
        row = ref2[i];
        if (row.data.id === id) {
          this.highlightRow(row);
          return;
        }
      }
    }
    return this.unhighlightRow();
  };

  LayerPanel.prototype.highlightRow = function(row) {
    this.setSelectedRows("hover", [row]);
    return this._highlightedLayerId = row.data.id;
  };

  LayerPanel.prototype.unhighlightRow = function() {
    this.setSelectedRows("hover", []);
    return this._highlightedLayerId = null;
  };

  LayerPanel.prototype.handleScrollerResize = function(width, height) {
    return this.width = width;
  };

  LayerPanel.prototype.handleStudioLayerPanelEnter = function() {
    console.log("layerPanel:handleStudioLayerPanelEnter");
    this.entered = true;
    return this.delay = Utils.delay(.25, (function(_this) {
      return function() {
        clearTimeout(_this.delay);
        _this.delay = null;
        if (_this.delayedRow != null) {
          _this.sendItemRollOver(_this.delayedRow);
        }
        return _this.delayedRow = null;
      };
    })(this));
  };

  LayerPanel.prototype.handleStudioLayerPanelLeave = function() {
    console.log("layerPanel:handleStudioLayerPanelLeave");
    if (this.delay != null) {
      clearTimeout(this.delay);
    }
    this.delayedRow = null;
    this.delay = null;
    return this.entered = false;
  };

  LayerPanel.prototype.sendItemRollOver = function(row) {
    if (this.entered && (this.delay == null)) {
      console.log("sentItemRollOver");
      this.highlightRow(row);
      return bridge.send(this.messages.itemRollOver, {
        id: row.data.id,
        data: row.data.__framerInstanceInfo
      });
    } else {
      return this.delayedRow = row;
    }
  };

  LayerPanel.prototype._textColor = function(data) {
    if (data.visibleResult) {
      return Constants.colors.text;
    }
    return Constants.colors.textInvisible;
  };

  return LayerPanel;

})(TableComponent);

Utils.convertPoint = function(input, layerA, layerB, context) {
  var i, j, layer, len, len1, point, superLayersA, superLayersB;
  if (context == null) {
    context = false;
  }
  point = _.defaults(input, {
    x: 0,
    y: 0
  });
  superLayersA = (layerA != null ? layerA.superLayers(context) : void 0) || [];
  superLayersB = (layerB != null ? layerB.superLayers(context) : void 0) || [];
  if (layerB) {
    superLayersB.push(layerB);
  }
  for (i = 0, len = superLayersA.length; i < len; i++) {
    layer = superLayersA[i];
    point.x += layer.x - layer.scrollFrame.x;
    point.y += layer.y - layer.scrollFrame.y;
  }
  for (j = 0, len1 = superLayersB.length; j < len1; j++) {
    layer = superLayersB[j];
    point.x -= layer.x + layer.scrollFrame.x;
    point.y -= layer.y + layer.scrollFrame.y;
  }
  return point;
};



},{"./../shared/Bridge":5,"./../shared/Constants":6,"./../shared/Utils":8,"./TableComponent":3}],3:[function(require,module,exports){
var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

exports.TableComponent = (function(superClass) {
  extend(TableComponent, superClass);

  function TableComponent(options) {
    if (options == null) {
      options = {};
    }
    this.renderRow = bind(this.renderRow, this);
    this.render = bind(this.render, this);
    if (options.name == null) {
      options.name = "TableComponent";
    }
    TableComponent.__super__.constructor.call(this, options);
    this._rowLayers = [];
    this._selectedRows = {};
    this.bumper = new Layer({
      backgroundColor: null
    });
  }

  TableComponent.prototype.render = function() {
    var i, index, j, ref, ref1, ref2, ref3, ref4, removalIndex, rowLayer, y;
    y = 0;
    if (this.totalRows() > 0) {
      for (index = i = 0, ref = this.totalRows() - 1; 0 <= ref ? i <= ref : i >= ref; index = 0 <= ref ? ++i : --i) {
        rowLayer = this._rowLayers[index];
        if (!rowLayer) {
          rowLayer = this._rowLayers[index] = this.createRow();
        }
        rowLayer.superLayer = this;
        _.extend(rowLayer, {
          y: y,
          width: this.width,
          height: this.heightForRow(index),
          visible: true
        });
        this.updateRow(index, rowLayer);
        y += rowLayer.height + this.marginForRow(index);
      }
    }
    for (removalIndex = j = ref1 = this.totalRows(), ref2 = this._rowLayers.length + 1; ref1 <= ref2 ? j <= ref2 : j >= ref2; removalIndex = ref1 <= ref2 ? ++j : --j) {
      if ((ref3 = this._rowLayers[removalIndex]) != null) {
        ref3.visible = false;
      }
      if ((ref4 = this._rowLayers[removalIndex]) != null) {
        ref4.data = null;
      }
    }
    this.bumper.y = y;
    this.bumper.height = 400;
    this.bumper.width = this.width;
    return this.height = y;
  };

  TableComponent.prototype.totalRows = function() {
    return 20;
  };

  TableComponent.prototype.createRow = function() {
    return new Layer;
  };

  TableComponent.prototype.heightForRow = function(index) {
    return 80;
  };

  TableComponent.prototype.marginForRow = function(index) {
    return 10;
  };

  TableComponent.prototype.updateRow = function(index, row) {
    return Utils.labelLayer(row, "index: " + index);
  };

  TableComponent.prototype.renderRow = function(row) {
    return this.updateRow(this.indexForRow(row), row);
  };

  TableComponent.prototype.indexForRow = function(row) {
    return this._rowLayers.indexOf(row);
  };

  TableComponent.prototype.rowForIndex = function(index) {
    var ref;
    return ((ref = this._rowLayers) != null ? ref[index] : void 0) || null;
  };

  TableComponent.prototype.setSelectedRows = function(type, rows) {
    var previousSelectedRows;
    if (_.isEqual(rows, this._selectedRows[type])) {
      return;
    }
    previousSelectedRows = this._selectedRows[type];
    this._selectedRows[type] = rows;
    _.map(previousSelectedRows, this.renderRow);
    _.map(this._selectedRows[type], this.renderRow);
    return this.emit("change:selection:" + type, {
      old: previousSelectedRows,
      "new": this._selectedRows[type]
    });
  };

  TableComponent.prototype.setSelectedRowIndexes = function(type, rowIndexes) {
    return this.setSelectedRows(_.map(rowIndexes, this.rowForIndex));
  };

  TableComponent.prototype.getSelectedRows = function(type) {
    return _.clone(this._selectedRows[type]) || [];
  };

  TableComponent.prototype.isRowSelected = function(type, row) {
    if (this._selectedRows[type]) {
      return indexOf.call(this._selectedRows[type], row) >= 0;
    }
  };

  TableComponent.prototype.unselectRows = function(type) {
    return this.setSelectedRows(type, []);
  };

  return TableComponent;

})(Framer.Layer);



},{}],4:[function(require,module,exports){
var Constants, LayerPanel, Scroller, scroller;

Constants = require("./../shared/Constants").Constants;

Scroller = require("./../shared/Scroller").Scroller;

LayerPanel = require("./LayerPanel").LayerPanel;

document.addEventListener("contextmenu", function(event) {
  return event.preventDefault();
}, false);

scroller = new Scroller({
  backgroundColor: Constants.colors.background
});

new LayerPanel({
  parent: scroller,
  backgroundColor: Constants.colors.background
});

Framer.Extras.TouchEmulator.disable();

Framer.Extras.ErrorDisplay.disable();



},{"./../shared/Constants":6,"./../shared/Scroller":7,"./LayerPanel":2}],5:[function(require,module,exports){
var Bridge, EventEmitter,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

EventEmitter = require("eventemitter3");

Bridge = (function(superClass) {
  extend(Bridge, superClass);

  function Bridge() {
    this.respond = bind(this.respond, this);
    this.receive = bind(this.receive, this);
    if (typeof window !== "undefined" && window !== null) {
      window._receive = this.receive;
    }
    if (typeof window !== "undefined" && window !== null) {
      window._respond = this.respond;
    }
    this.count = 0;
    this.responders = {};
  }

  Bridge.prototype.receive = function(command, info) {
    if (this.debug) {
      console.log((this.count++) + " bridge.receive", command, info);
    }
    return this.emit(command, info);
  };

  Bridge.prototype.respond = function(request, info) {
    var responder;
    responder = this.responders[request];
    if (responder != null) {
      return responder(info);
    } else {

    }
  };

  Bridge.prototype.send = function(command, info) {
    if (this.debug) {
      console.log((this.count++) + " bridge.send", command, info);
    }
    return typeof window !== "undefined" && window !== null ? typeof window._bridge === "function" ? window._bridge(command, info) : void 0 : void 0;
  };

  return Bridge;

})(EventEmitter);

exports.bridge = new Bridge();



},{"eventemitter3":1}],6:[function(require,module,exports){
exports.Constants = {
  fonts: {
    "default": {
      font: "11px -apple-system, Helvetica Neue, Helvetica",
      weight: "500"
    }
  },
  colors: {
    background: "#141414",
    text: "#888888",
    textHighlight: "#FFFFFF",
    textInvisible: "rgba(98,98,98,.4)",
    indent: "#303030",
    tableSelectionBackground: "#363636"
  },
  sizes: {
    base: 10,
    rowHeight: 28,
    indent: 12,
    indentWidth: 1,
    indentHeight: 28
  },
  messages: {
    layerpanel: {
      reset: "layerPanel:reset",
      itemRollOver: "layerPanel:itemRollover",
      itemRollOut: "layerPanel:itemRollout",
      itemClick: "layerPanel:itemClick"
    },
    propertiespanel: {
      propertiesChanged: "propertiesPanel:propertiesChanged",
      propertyChanged: "propertiesPanel:propertyChanged",
      propertyLockClicked: "propertiesPanel:propertyLockClicked",
      activatePanel: "propertiesPanel:activatePanel"
    },
    framerview: {
      layers: "framerView:layers",
      layerEdited: "framerView:layerEdited",
      layerHighlighted: "framerView:layerHighlighted"
    },
    studio: {
      state: "studio:state",
      layerPanelEnter: "studio:layerPanelEnter",
      layerPanelLeave: "studio:layerPanelLeave"
    }
  }
};



},{}],7:[function(require,module,exports){
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

exports.Scroller = (function(superClass) {
  extend(Scroller, superClass);

  function Scroller(options) {
    var ref;
    if (options == null) {
      options = {};
    }
    this.marginTop = (ref = options.y) != null ? ref : 0;
    Scroller.__super__.constructor.call(this, _.defaults(options, {
      name: "Scroller",
      y: this.marginTop,
      width: window.innerWidth,
      height: window.innerHeight - this.marginTop,
      backgroundColor: null,
      clip: true
    }));
    this.scroll = true;
    this.scrollHorizontal = false;
    window.addEventListener("resize", (function(_this) {
      return function() {
        var child, i, len, ref1, results;
        _this.height = window.innerHeight - _this.marginTop;
        _this.width = window.innerWidth;
        ref1 = _this.children;
        results = [];
        for (i = 0, len = ref1.length; i < len; i++) {
          child = ref1[i];
          results.push(typeof child.handleScrollerResize === "function" ? child.handleScrollerResize(_this.width, _this.height) : void 0);
        }
        return results;
      };
    })(this));
  }

  return Scroller;

})(Layer);



},{}],8:[function(require,module,exports){
var utils;

utils = {};

utils.subLayers = function(superLayerId, layers) {
  return _.filter(layers, function(item) {
    return item.superLayer === superLayerId;
  });
};

utils.sortLayersByIndex = function(layers) {
  return layers.sort(function(b, a) {
    return a.index - b.index;
  });
};

utils.sortLayersByHierarchy = function(layers) {
  var i, layer, len, ref, result, traverse;
  result = [];
  traverse = function(layer, level) {
    var subLayers;
    if (level == null) {
      level = 0;
    }
    layer.level = level;
    if (layer.name.length > 0 && layer.name.split("")[0] === ".") {
      return;
    }
    result.push(layer);
    subLayers = utils.subLayers(layer.id, layers);
    subLayers = utils.sortLayersByIndex(subLayers);
    return subLayers.map(function(subLayer) {
      return traverse(subLayer, level + 1);
    });
  };
  ref = utils.sortLayersByIndex(utils.subLayers(null, layers));
  for (i = 0, len = ref.length; i < len; i++) {
    layer = ref[i];
    traverse(layer);
  }
  return result;
};

_.extend(exports, utils);



},{}]},{},[4])