//
//  Common.h
//  AuroraTest
//
//  Created by San Byn Nguyen on 21.06.2023.
//

#ifndef Common_h
#define Common_h

#import <simd/simd.h>

typedef signed char BOOL;
#define TRUE ((BOOL)1)
#define FALSE ((BOOL)0)

typedef struct {
//    matrix_float3x3 transformationMatrix;
    float time;
} FragmentUniforms;

typedef struct {
    vector_float2 center;
    vector_float2 size;
} BlurUniforms;

typedef struct {
    float sigma;
    float direction_blur_power;
    uint8_t direction_blur_sampling_count;
    
    float spin_blur_power;
    uint8_t spin_blur_sampling_count;
    
    float noisePower;
    uint8_t noiseTexture;
    
    float timeMultiplier;
    float fishEyeMultiplier;
    BOOL rippleOn;
    BOOL noiseOn;
    BOOL fisheyeOn;
    BOOL maskOn;
    BOOL opaque;
} Uniforms;

#endif /* Common_h */
